package com.jsrsys.web;
/******************************************************************************
// JsrLineIn.java:    
 * to simplify input of *.txt type files.
 * Sample Use:
 * JsrLineIn file1 = new JsrLineIn();
 * String[] strfile1[2];
 * strfile1[0] = "C:\reqlook.dxx"
 * while (0 <= file1.read(strfile1[]))
      {   process records from strfile1[1];
 *    }
 *------------------------------------------------------------
 *2001-09-15 add getRecordLength (does open, read first rec, close, return record length).
 *2000-06-25 add following methods to make more "object" like.
 * illustrated by "sample" use.
 * JsrLineIn file1 = new JsrLineIn();
 * String file1Name = "input.txt";
 * String file1Line;
 * file1.setName(file1Name); // open new file (close old if one is open).
 *                           // this is a noOP if file1Name matches open file.
 * while (0 <== file1.getNext() // reads next record
 * {                            // returns rec# or -rec# for EOF
 *    file1Line = file1.getLine(); // process records here
 * }
 * also: int getCount(); returns current record counter
 * example: (at EOF rec# is negative)
 *          int recordsRead = - file1.getCount();
*/

import java.io.*;

public class JsrLineIn
{ 
  static final String COPYRIGHT = 
  "Copyright 1998-2000, JSR Systems.  See: www.Jsrsys.com/copyright.";

  int                   recNum = 0; // 0 if no open files (see eofNum)!
  int                   eofNum = 0; // - recNum of last file closed!
  String                fileLine = ""; // last Line (record) read.
  String                fileName = ""; // name of last open file.
  
//1.0  DataInputStream       inFileStream;
//1.0  DataInput             inFile;
  BufferedReader             inFile;

  JsrSysout sysout = new JsrSysout();
  JsrUtil        u = new JsrUtil();
  public JsrLineIn()  // null constructor
  {
  }

  int open(String parmName)   
  {
     if (recNum != 0)
     {
        close();
     }
     // sysout.display("Open   Input: " + parmName);   // move to after FileNotFound:
     // open code here
     fileName = parmName;
     recNum = 0;

//1.0     try {inFileStream =
//1.0             new DataInputStream(new FileInputStream ( fileName));
//1.0          inFile =  inFileStream;
     try {inFile = new BufferedReader(new InputStreamReader
                                     (new FileInputStream ( fileName)),1000000);
         } catch (FileNotFoundException eFNF)
                 {sysout.display("FileNotFound: " + fileName);
                  recNum=-1;  eofNum=-1; // 
                 }
     if (recNum == 0) sysout.display("Open   Input: " + parmName);
     return recNum;
  } 
  public int close()   
  {  
     sysout.display("Close  Input: " + u.padLeft (recNum,  10)
                   + " Records: "    + u.padRight(fileName,44));  

     if (recNum >= 0)
     {
//1.0  try {inFileStream.close();   // free up resource
       try {inFile.close();   // free up resource
           }catch ( IOException  eIO )
                  {sysout.display("I/OError! "   + fileName); }
     }
     if (recNum == 0)
         eofNum = -1;
     else
         eofNum   = - recNum;
     recNum = 0;
     fileName = "";
     //sysout.display("closeReturn: "+eofNum+": "+recNum);
     return eofNum;
  }
  
// the following "object" methods were added 2000-06-35

  public int getCount()
  {
    if (recNum > 0) return recNum; // file currently open
    else            return eofNum; // eof (- count) last file Read
  }

  public void setName(String parmName)  // oops, this will require re-compile of many programs.  
  {
     if (!parmName.equals(fileName))
     {
        open(parmName);
     }
     return;
  }

  public int getNext()
  {
     if (fileName.equals(""))
     {
        sysout.display("JsrLineIn--must use setName([name of File])!!!");
        sysout.display("JsrLineIn--before reading w/ getNext()!!!!!!!!");
        return -1;
     }
     if (recNum >= 0)
     {
       try {fileLine = inFile.readLine();
           } 
             catch ( IOException  eIO )
                   {sysout.display("I/OError! "   + fileName); }
       if (fileLine == null)
          return close();
       else
          recNum++;
     }
     // sysout.display ("recNum="+recNum+ "Rec="+ fileLine);
     return recNum;
  }

  public String getLine() 
  {
    if (fileLine == null)
       return "";
    else
       return fileLine;
  }

  int getRecordLength(String fileName)
  {
      int LRECL = open(fileName);
      if (LRECL >= 0)
      {
        LRECL = getNext();
        if (LRECL >= 0)
           LRECL = fileLine.length();
      }
      return LRECL;
  }

// the following method is kept for backward compatability!
  int read(String nameRecord[])   
  {
      //  sysout.display("Read: " + nameRecord[0]);   
     if (!nameRecord[0].equals(fileName))
     {
        open(nameRecord[0]);
     }
     if (recNum >= 0)
     {
       try {nameRecord[1] = inFile.readLine();
           } 
             catch ( IOException  eIO )
                   {sysout.display("I/OError! "   + fileName); }
       if (nameRecord[1] == null)
          return close();
       else
          recNum++;
     }
     // sysout.display ("recNum="+recNum+ "Rec="+ nameRecord[1]);
     return recNum;
  } 
} 
