package FilePrinter;

import java.io.*;	// include Java's IO library

/**
 * FilePrinter application - displays the contents of the file or files passed on 
 * the command line to standard out.
 */
class FilePrinter {

  /**
   * Main entry point - display the contents of each file
   */
  public static void main(String[] args) 
  throws IOException, FileNotFoundException {

    for (int f=0; f < args.length; f++) {
      displayFile(args[f]);
    }
   
  } // end of main method


  /**
   * Pretty print the contents of a file to the screen, but fails to handle any 
   * exceptions
   */
  private static void displayFile(String fileName) 
  throws IOException, FileNotFoundException {
    
    System.out.println(fileName + ":");
    System.out.println();

    FileReader fileReader = null;

    // TO DO (1) : start your try block here...

    fileReader = new FileReader(fileName);    // may throw a FileNotFoundException
    int c;
    while ( (c = fileReader.read()) != -1) {  // may throw an IOException
      System.out.print((char)c);
    }        

    System.out.println();
    fileReader.close();                       // may throw an IOException

    // TO DO (2) : end your try block here and add some catch handlers

    // TO DO (3) : add a finally block, and move the fileReader.close 
    //             statement into it

  } // end of displayFile method


} // end of class
