package FilePrinter;

import java.io.*;	// include Java's IO library

/**
 * FilePrinter application - displays the contents of the file or files passed on 
 * the command line to standard out.
 */
class FilePrinter {

  /**
   * Main entry point - display the contents of each file
   */
  public static void main(String[] args) {

    for (int f=0; f < args.length; f++) {
      displayFile(args[f]);
    }
   
  } // end of main method


  /**
   * Pretty print the contents of a file to the screen, but fails to handle any 
   * exceptions
   */
  private static void displayFile(String fileName) {
    
    System.out.println(fileName + ":");
    System.out.println();

    FileReader fileReader = null; // declare outside of the scope of the try block
    try {
      fileReader = new FileReader(fileName);
      int c;
      while ( (c = fileReader.read()) != -1) {
        System.out.print((char)c);
      }        
    }
    catch (FileNotFoundException notFoundEx) {
      System.out.println("Could not open " + fileName);
    }
    catch (IOException ioEx) {
      System.out.println("Error reading from " + fileName);
    }
    finally {
      System.out.println();
      if (fileReader != null) { 
        try { fileReader.close(); } 
        catch (IOException ioEx) { ; } // nothing we can do now!
      }
    }
            
  } // end of displayFile method


} // end of class