/*
 * Decompiled with CFR 0.152.
 */
package com.jsrsys.web;

import com.jsrsys.web.JsrLineIn;
import com.jsrsys.web.JsrSysout;
import com.jsrsys.web.JsrUtil;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class JsrSendMail {
    static final String COPYRIGHT = "Copyright 2004, JSR Systems. \n             See: www.JsrSys.com/copyright.";
    JsrUtil u = new JsrUtil();
    JsrSysout sysout = new JsrSysout();
    JsrLineIn input = new JsrLineIn();
    String to = "";
    int toComma = 0;
    String from = "";
    String cc = "";
    String bcc = "";
    String host = "mail.jsrsys.com";
    String[] fileName = new String[]{""};
    String msgText = "";
    StringBuffer msgBuffer = new StringBuffer();
    String subject = "";
    boolean debug = false;
    Session session;

    public static void main(String[] args) {
        JsrSendMail sendFile = new JsrSendMail();
        sendFile.setParms(args);
        sendFile.checkTo();
        System.exit(0);
    }

    private void checkTo() {
        if (this.to.indexOf(64) > 0) {
            this.sendMail();
        } else {
            this.input.setName(this.to);
            while (this.input.getNext() > 0) {
                this.to = this.input.getLine();
                this.toComma = this.to.indexOf(44);
                if (this.toComma > 1) {
                    this.cc = this.to.substring(this.toComma + 1);
                    this.to = this.to.substring(0, this.toComma);
                }
                this.sendMail();
            }
            this.sysout.display("JsrSendMail--" + this.u.getDateTimeAll() + " " + COPYRIGHT);
        }
    }

    private void setParms(String[] parm) {
        this.sysout.syslog("syslogJsrSendMail.txt");
        this.sysout.display("JsrSendMail--" + this.u.getDateTimeAll() + " " + COPYRIGHT);
        int pMax = 0;
        int p = 0;
        while (p < parm.length) {
            if (parm[p].equals("-t")) {
                this.to = parm[++p];
                pMax = p;
            }
            if (parm[p].equals("-f")) {
                this.from = parm[++p];
                pMax = p;
            }
            if (parm[p].equals("-s")) {
                this.subject = parm[++p];
                pMax = p;
            }
            if (parm[p].equals("-h")) {
                this.host = parm[++p];
                pMax = p;
            }
            if (parm[p].equals("-c")) {
                this.cc = parm[++p];
                pMax = p;
            }
            if (parm[p].equals("-b")) {
                this.bcc = parm[++p];
                pMax = p;
            }
            if (parm[p].equals("-m")) {
                this.collect(parm[++p]);
                pMax = p;
            }
            if (parm[p].equals("-d")) {
                this.debug = true;
                pMax = p;
            }
            ++p;
        }
        this.msgText = this.msgBuffer.toString();
        ++pMax;
        boolean error = false;
        if (this.to.length() == 0) {
            this.sysout.display("JsrSendMail: To      (-t) is required.");
            error = true;
        }
        if (this.from.length() == 0) {
            this.sysout.display("JsrSendMail: From    (-f) is required.");
            error = true;
        }
        if (this.subject.length() == 0) {
            this.sysout.display("JsrSendMail: Subject (-s) is required.");
            error = true;
        }
        if (error) {
            this.sysout.display("usage: java JsrSendMail <parameters>");
            this.sysout.display("            -t <to> -f <from> -s <Subject> -H <smtp.host.com> ");
            this.sysout.display("            -m <message>  -c <cc> -b <bcc> <file1> <file2>...");
            this.sysout.display("            -t, -f, -s are required.  Others are optional.");
            this.sysout.display("            <file1>... are files to be attached.");
            this.sysout.display("            if <to> does not contain at least one \"@\", ");
            this.sysout.display("                    assume <to> is a toFileName.");
            this.sysout.display("                    if toFileLine has \",\" split between to and cc.");
            this.sysout.display("            if <message> byte 1 = \":\" use as text, else read file.");
            this.sysout.display("            Multiple -m <...> -m <...> are allowed.");
            System.exit(4);
        }
        if (parm.length > pMax) {
            this.fileName = new String[parm.length - pMax];
            int p2 = pMax;
            int f = 0;
            while (f < this.fileName.length) {
                this.fileName[f] = parm[p2];
                ++p2;
                ++f;
            }
        }
    }

    private void collect(String msgFileName) {
        if (msgFileName.substring(0, 1).equals(":")) {
            this.msgBuffer.append(msgFileName.substring(1));
            this.msgBuffer.append("\n");
        } else {
            this.input.setName(msgFileName);
            while (this.input.getNext() > 0) {
                if (this.input.getLine().length() <= 0) continue;
                this.msgBuffer.append(this.input.getLine());
                this.msgBuffer.append("\n");
            }
        }
    }

    private void setSession() {
        Properties props = System.getProperties();
        props.put("mail.smtp.host", this.host);
        this.session = Session.getInstance((Properties)props, null);
    }

    public void setHost(String newHost) {
        this.host = newHost;
    }

    public void setTo(String address) {
        this.to = address;
    }

    public void setCc(String address) {
        this.cc = address;
    }

    public void setBcc(String address) {
        this.bcc = address;
    }

    public void setFrom(String address) {
        this.from = address;
    }

    public void setMsgText(String newMsgText) {
        this.msgText = newMsgText;
    }

    public void setSubject(String newSubject) {
        this.subject = newSubject;
    }

    public void setFileName(String[] newFileName) {
        this.fileName = newFileName;
    }

    public void sendMail() {
        block21: {
            boolean error = false;
            if (this.session == null) {
                this.setSession();
            }
            if (this.from == null || this.from.length() < 1) {
                this.sysout.display("JsrSendMail: from is required.");
                error = true;
            }
            if (this.to == null || this.to.length() < 1) {
                this.sysout.display("JsrSendMail: to field is required.");
                error = true;
            }
            if (this.msgText == null || this.msgText.length() < 1) {
                this.sysout.display("JsrSendMail: msgText is required.");
                error = true;
            }
            if (this.subject == null || this.subject.length() < 1) {
                this.sysout.display("JsrSendMail: subject is required.");
                error = true;
            }
            if (this.host == null || this.host.length() < 1) {
                this.sysout.display("JsrSendMail: host (SMTP host) is required.");
                error = true;
            }
            if (error) {
                this.sysout.display("JsrSendMail: mail not sent due to above error");
                return;
            }
            try {
                int f;
                MimeMessage msg = new MimeMessage(this.session);
                msg.setFrom((Address)new InternetAddress(this.from));
                msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.to, (boolean)false));
                msg.setSubject(this.subject);
                if (this.cc != null && this.cc.length() > 0) {
                    msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)this.cc, (boolean)false));
                }
                if (this.bcc != null && this.bcc.length() > 0) {
                    msg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)this.bcc, (boolean)false));
                }
                MimeBodyPart mbp1 = new MimeBodyPart();
                if (this.msgText.substring(0, 1).equals("<")) {
                    mbp1.setContent((Object)this.msgText, "text/html");
                } else {
                    mbp1.setText(this.msgText);
                }
                MimeMultipart mp = new MimeMultipart();
                mp.addBodyPart((BodyPart)mbp1);
                if (this.fileName.length > 0) {
                    f = 0;
                    while (f < this.fileName.length) {
                        if (this.fileName[f] != null && this.fileName[f].length() > 0) {
                            MimeBodyPart mbp2 = new MimeBodyPart();
                            FileDataSource fds = new FileDataSource(this.fileName[f]);
                            mbp2.setDataHandler(new DataHandler((DataSource)fds));
                            mbp2.setFileName(fds.getName());
                            mp.addBodyPart((BodyPart)mbp2);
                        }
                        ++f;
                    }
                }
                msg.setContent((Multipart)mp);
                msg.setSentDate(new Date());
                Transport.send((Message)msg);
                this.sysout.display("JsrSendMail: To: " + this.to + " Date: " + this.u.getDateTimeAll());
                if (this.cc.length() > 0) {
                    this.sysout.display("             CC: " + this.cc);
                }
                if (this.bcc.length() > 0) {
                    this.sysout.display("            BCC: " + this.bcc);
                }
                this.sysout.display("    Subject: " + this.subject);
                if (this.fileName.length > 0) {
                    f = 0;
                    while (f < this.fileName.length) {
                        if (this.fileName[f] != null && this.fileName[f].length() > 0) {
                            this.sysout.display("       File: " + this.fileName[f]);
                        }
                        ++f;
                    }
                }
            }
            catch (MessagingException mex) {
                this.sysout.display("JsrSendMail--MailError: " + (Object)((Object)mex));
                Exception ex = null;
                ex = mex.getNextException();
                if (ex == null) break block21;
                this.sysout.display("JsrSendMail--MailError: " + ex);
            }
        }
    }
}

