/*
 * Decompiled with CFR 0.152.
 */
package com.jsrsys.web;

import com.jsrsys.web.JsrLineIn;
import com.jsrsys.web.JsrLineOut;
import com.jsrsys.web.JsrSysout;
import com.jsrsys.web.JsrUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class JsrSQL {
    static final String COPYRIGHT = "Copyright 1998-2003, JSR Systems.  See: www.Jsrsys.com/copyright.";
    static final String DBHOST = "localhost";
    Connection conn;
    String dataBaseName = "";
    Statement stmt;
    ResultSet results;
    ResultSetMetaData rsmd;
    static JsrUtil u = new JsrUtil();
    JsrSysout sysout = new JsrSysout();
    JsrLineIn in = new JsrLineIn();
    JsrLineOut out = new JsrLineOut();
    String sql = "";
    static int tableNum = 0;
    static String[] tableName;
    int tableRow = 0;
    int rowCount = 0;
    int numberOfColumns = 0;
    String type;
    int i = 0;
    int firstParen = 0;
    int lastParen = 0;
    String[] fieldName;
    String[] fieldType;
    String[] fieldLen;
    String[] rowValue;
    boolean newRow = false;
    String[] colNames;
    int[] displaySizes;
    boolean forUpdate = false;

    public JsrSQL() {
    }

    public JsrSQL(String dbName) {
        this.setDataBaseName(dbName);
    }

    public void setDataBaseName(String dbName) {
        this.dataBaseName = dbName;
        this.connect(this.dataBaseName);
    }

    public int setSelectForUpdate(String fromName) {
        this.forUpdate = true;
        return this.setSelect(fromName);
    }

    public int setSelect(String fromName) {
        int rowCount = 0;
        try {
            if (this.forUpdate) {
                this.stmt = this.conn.createStatement(1003, 1008);
                this.forUpdate = false;
            } else {
                this.stmt = this.conn.createStatement();
            }
            this.sql = "SELECT COUNT(*) FROM " + fromName;
            this.results = this.stmt.executeQuery(this.sql);
            if (this.results == null) {
                this.sysout.display(" setSelect: result set is NULL");
                rowCount = 0;
                this.numberOfColumns = 0;
                this.rowValue = new String[1];
                this.rowValue[0] = "";
            } else {
                this.results.next();
                rowCount = this.results.getInt(1);
                this.sql = "SELECT * FROM " + fromName;
                this.results = this.stmt.executeQuery(this.sql);
                this.rsmd = this.results.getMetaData();
                this.numberOfColumns = this.rsmd.getColumnCount();
                this.rowValue = new String[this.numberOfColumns];
            }
            this.sysout.display(" setSelect: " + this.sql);
            this.sysout.display(" " + rowCount + " rows " + this.numberOfColumns + " cols found in result set");
        }
        catch (SQLException E) {
            this.sysout.display(" setSelect: " + this.sql);
            this.sysout.display(" exception: " + E.getMessage());
            rowCount = 0;
            this.numberOfColumns = 0;
            this.rowValue = new String[1];
            this.rowValue[0] = "";
        }
        return rowCount;
    }

    public int setSQL(String fromSQL) {
        int colCount = 0;
        boolean areResults = false;
        try {
            this.stmt = this.conn.createStatement();
            areResults = this.stmt.execute(fromSQL);
            if (!areResults) {
                this.sysout.display(" setSQL: colCount==0 for " + fromSQL);
                colCount = 0;
                this.numberOfColumns = 0;
                this.rowValue = new String[1];
                this.rowValue[0] = "";
            } else {
                this.results = this.stmt.getResultSet();
                this.rsmd = this.results.getMetaData();
                colCount = this.numberOfColumns = this.rsmd.getColumnCount();
                this.rowValue = new String[this.numberOfColumns];
            }
            this.sysout.display(" setSQL: " + fromSQL);
            this.sysout.display(" " + this.numberOfColumns + " cols found in result set");
        }
        catch (SQLException E) {
            this.sysout.display(" setSql: " + fromSQL);
            this.sysout.display(" exception: " + E.getMessage());
            colCount = 0;
            this.numberOfColumns = 0;
            this.rowValue = new String[1];
            this.rowValue[0] = "";
        }
        return colCount;
    }

    public int setIUD(String fromSQL) {
        int rowCount = 0;
        try {
            this.stmt = this.conn.createStatement();
            this.sql = fromSQL;
            rowCount = this.stmt.executeUpdate(this.sql);
            this.sysout.display(" setIUD: " + this.sql + " " + rowCount + " rows updated");
        }
        catch (SQLException E) {
            this.sysout.display(" setIUD: " + this.sql);
            this.sysout.display(" exception: " + E.getMessage());
            rowCount = 0;
        }
        return rowCount;
    }

    public String[] getColNames() {
        this.colNames = new String[this.numberOfColumns];
        int i = 0;
        while (i < this.numberOfColumns) {
            try {
                this.colNames[i] = this.rsmd.getColumnName(i + 1);
            }
            catch (SQLException E) {
                this.sysout.display(" getColumnName exception: " + E.getMessage());
            }
            ++i;
        }
        return this.colNames;
    }

    public int[] getColDisplaySize() {
        this.displaySizes = new int[this.numberOfColumns];
        int i = 0;
        while (i < this.numberOfColumns) {
            try {
                this.displaySizes[i] = this.rsmd.getColumnDisplaySize(i + 1);
            }
            catch (SQLException E) {
                this.sysout.display(" getColumnDisplaySize exception: " + E.getMessage());
            }
            ++i;
        }
        return this.displaySizes;
    }

    public boolean setNextRow() {
        boolean isNext = false;
        try {
            isNext = this.results.next();
        }
        catch (SQLException E) {
            this.sysout.display(" setNextRow SQL exception: " + E.getMessage());
        }
        catch (NullPointerException E) {
            this.sysout.display(" setNextRow SQL result set is NULL: " + E.getMessage());
        }
        return isNext;
    }

    public String[] getRowValues() {
        int k = 0;
        while (k < this.rowValue.length) {
            this.rowValue[k] = this.getString(k + 1);
            ++k;
        }
        return this.rowValue;
    }

    public String delete(String[] newRowValue) {
        String status = "****";
        this.sysout.display("Deleting Row *ID=" + newRowValue[0]);
        try {
            this.results.deleteRow();
        }
        catch (SQLException E) {
            this.sysout.display(" deleteRow() SQL exception: " + E.getMessage());
            status = "SQL: " + E.getMessage();
        }
        if (status.equals("****")) {
            status = String.valueOf(status) + " row deleted!!!";
        }
        return status;
    }

    public String update(String[] newRowValue) {
        String status = "****";
        this.newRow = false;
        int fieldsChanged = 0;
        if (newRowValue[1] != null && newRowValue[1].equals("*new*")) {
            try {
                this.results.moveToInsertRow();
            }
            catch (SQLException E) {
                this.sysout.display(" moveToInsertRow " + E.getMessage());
            }
            this.sysout.display("JsrSQL: Assume addition");
            this.newRow = true;
        }
        int k = 0;
        while (k < this.rowValue.length) {
            if (this.newRow || !this.rowValue[k].equals(newRowValue[k])) {
                ++fieldsChanged;
                try {
                    this.sysout.display("Updating " + this.colNames[k] + " to: " + newRowValue[k] + " from: " + this.rowValue[k]);
                    this.results.updateString(k + 1, newRowValue[k]);
                    this.rowValue[k] = newRowValue[k];
                }
                catch (Exception E) {
                    this.sysout.display(" update(" + (k + 1) + ") SQL exception: " + E.getMessage());
                    status = "SQL: " + E.getMessage();
                }
            }
            ++k;
        }
        if (status.equals("****") && fieldsChanged > 0) {
            this.sysout.display("Updating Row *ID=" + newRowValue[0]);
            try {
                this.rowValue[1] = u.getDateTime().substring(0, 16);
                this.results.updateString(2, this.rowValue[1]);
                if (this.newRow) {
                    this.results.insertRow();
                    this.results.last();
                } else {
                    this.results.updateRow();
                }
            }
            catch (SQLException E) {
                this.sysout.display(" updateRow() SQL exception: " + E.getMessage());
                status = "SQL: " + E.getMessage();
            }
            catch (Exception E) {
                this.sysout.display(" updateRow() Exception: " + E.getMessage());
                status = "***: " + E.getMessage();
            }
        }
        if (status.equals("****")) {
            status = String.valueOf(status) + " " + fieldsChanged + " fields were changed.";
        }
        return status;
    }

    public String getString(int colNum) {
        String fixResult;
        block5: {
            try {
                fixResult = this.results.getString(colNum);
            }
            catch (SQLException E) {
                if (this.newRow) {
                    fixResult = this.rowValue[colNum - 1];
                }
                fixResult = "";
                if (colNum != 2) break block5;
                fixResult = "*new*";
            }
        }
        if (fixResult == null) {
            fixResult = "";
            if (colNum == 2) {
                fixResult = "*new*";
            }
        }
        return fixResult;
    }

    public String getString(String colName) {
        String fixResult;
        block4: {
            try {
                fixResult = this.results.getString(colName);
            }
            catch (SQLException E) {
                fixResult = "";
                if (!colName.equals("LastUpdate")) break block4;
                fixResult = "*new*";
            }
        }
        if (fixResult == null) {
            fixResult = "";
        }
        if (colName.equals("LastUpdate")) {
            fixResult = "*new*";
        }
        return fixResult;
    }

    private void connect(String dbName) {
        try {
            Class.forName("org.gjt.mm.mysql.Driver");
        }
        catch (Exception E) {
            this.sysout.display(" Unable to load driver");
            E.printStackTrace();
        }
        try {
            this.sql = "Connection to jdbc/MySql:";
            InitialContext myContext = new InitialContext();
            Context envContext = (Context)myContext.lookup("java:comp/env");
            DataSource ds = (DataSource)envContext.lookup("jdbc/MySql");
            this.conn = ds.getConnection();
            this.stmt = this.conn.createStatement();
            this.sql = "USE " + dbName;
            this.stmt.execute(this.sql);
            this.sysout.display(String.valueOf(this.sql) + ": connection to jdbc/MySql established.");
        }
        catch (SQLException E) {
            this.sysout.display(String.valueOf(this.sql) + ": connect SQL exception: " + E.getMessage());
        }
        catch (Exception eOther) {
            this.sysout.display(String.valueOf(this.sql) + ": connect Other exception: " + eOther.getMessage());
        }
    }

    public void close() {
        try {
            if (this.results != null) {
                this.results.close();
            }
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException E) {
            this.sysout.display(" close SQL exception: " + E.getMessage());
        }
        catch (NullPointerException E) {
            this.sysout.display(" close SQL result set is NULL: " + E.getMessage());
        }
    }

    public int getFields(String tableName) {
        try {
            this.sql = "DESCRIBE " + tableName;
            this.sysout.display(" getFields executeQuery: " + this.sql);
            this.results = this.stmt.executeQuery(this.sql);
            this.tableRow = 0;
            while (this.results.next()) {
                ++this.tableRow;
            }
            this.fieldName = new String[this.tableRow];
            this.fieldType = new String[this.tableRow];
            this.fieldLen = new String[this.tableRow];
            this.rowValue = new String[this.tableRow];
            this.results = this.stmt.executeQuery(this.sql);
            int i = 0;
            while (this.results.next()) {
                this.fieldName[i] = this.getString(1);
                this.type = this.getString(2);
                this.firstParen = this.type.indexOf("(");
                this.lastParen = this.type.indexOf(")");
                if (this.firstParen > 0 && this.lastParen > this.firstParen) {
                    this.fieldLen[i] = this.type.substring(this.firstParen + 1, this.lastParen);
                    this.fieldType[i] = this.type.substring(0, this.firstParen);
                } else {
                    this.fieldLen[i] = "";
                    this.fieldType[i] = this.type;
                }
                ++i;
            }
        }
        catch (SQLException E) {
            this.sysout.display(" getFields SQL exception: " + E.getMessage());
        }
        return this.tableRow;
    }

    public String[] getNames() {
        return this.fieldName;
    }

    public String[] getTables(String dbName) {
        if (tableNum == 0) {
            this.connect(dbName);
        }
        try {
            this.sql = "SHOW TABLES";
            this.sysout.display(" get Tables executeQuery: " + this.sql);
            this.results = this.stmt.executeQuery(this.sql);
            tableNum = 0;
            while (this.results.next()) {
                ++tableNum;
            }
            this.sysout.display("# Tables in " + dbName + ": " + tableNum);
            tableName = new String[tableNum];
            this.results = this.stmt.executeQuery(this.sql);
            this.i = 0;
            while (this.results.next()) {
                JsrSQL.tableName[this.i] = this.getString(1);
                JsrSQL.tableName[this.i] = String.valueOf(tableName[this.i].substring(0, 1).toUpperCase()) + tableName[this.i].substring(1);
                this.sysout.display(String.valueOf(this.i + 1) + " " + tableName[this.i]);
                ++this.i;
            }
        }
        catch (SQLException E) {
            this.sysout.display(" getTables SQL exception: " + E.getMessage());
        }
        return tableName;
    }
}

