/*
 * Decompiled with CFR 0.152.
 */
package com.jsrsys.web;

import com.jsrsys.web.JsrSysout;
import com.jsrsys.web.JsrUtil;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class JsrLineOut {
    static final String COPYRIGHT = "Copyright 1998-2000, JSR Systems.  See: www.Jsrsys.com/copyright.";
    boolean flushOn = false;
    int recNum = 0;
    String fileName = "";
    String lastName = "";
    BufferedWriter outFile;
    JsrSysout sysout;
    boolean displayOn;
    JsrUtil u = new JsrUtil();

    public JsrLineOut() {
        this.sysout = new JsrSysout();
        this.displayOn = true;
    }

    public JsrLineOut(String noLog) {
        this.displayOn = false;
    }

    int open(String parmName) {
        if (this.recNum > 0) {
            this.sysout.display("JsrLineOut-open: recNum=" + this.recNum + " fileName=" + this.fileName + "!" + " parmName=" + parmName + "!");
            this.close();
        }
        if (this.displayOn) {
            this.sysout.display("Open  Output: " + parmName);
        }
        this.fileName = parmName;
        this.recNum = 0;
        try {
            this.outFile = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.fileName)), 1000000);
        }
        catch (IOException eIO) {
            System.out.println("I/OError! " + this.fileName);
            this.recNum = -1;
        }
        return this.recNum;
    }

    public int close() {
        if (this.fileName.length() == 0) {
            return -1;
        }
        if (this.recNum > 0) {
            if (this.displayOn) {
                this.sysout.display("Close Output: " + this.u.padLeft(this.recNum, 10) + " Records: " + this.fileName + "                          ");
            }
            try {
                this.outFile.close();
            }
            catch (IOException eIO) {
                System.out.println("I/OError! " + this.fileName);
            }
            catch (Exception eX) {
                System.out.println("JsrLineOut--Close Exception: " + eX + " on file: " + this.fileName);
                this.recNum = 9999;
            }
        }
        this.recNum = -this.recNum;
        this.lastName = this.fileName;
        this.fileName = "";
        return this.recNum;
    }

    public void setName(String parmName) {
        if (parmName.length() == 0) {
            this.sysout.display("Open Output: Failed-Blank File Name!!!");
            this.recNum = -1;
            return;
        }
        if (!parmName.equals(this.fileName)) {
            this.open(parmName);
        }
    }

    public int setLine(String parmLine) {
        if (this.recNum >= 0) {
            if (this.fileName.equals("")) {
                this.fileName = this.lastName;
            }
            try {
                this.outFile.write(parmLine);
                this.outFile.newLine();
                if (this.flushOn) {
                    this.outFile.flush();
                }
            }
            catch (IOException eIO) {
                System.out.println("I/OError! " + this.fileName);
            }
            catch (Exception eX) {
                System.out.println("JsrLineOut--setLine Exception: " + eX + " on file: " + this.fileName);
                System.out.println("JsrLineOut--setLine: " + parmLine);
            }
        }
        ++this.recNum;
        return this.recNum;
    }

    public void setFlush(boolean parmTF) {
        this.flushOn = parmTF;
    }

    int write(String parmName, String parmLine) {
        this.setName(parmName);
        return this.setLine(parmLine);
    }

    int write(String[] nameRecord) {
        this.setName(nameRecord[0]);
        return this.setLine(nameRecord[1]);
    }
}

