<!--
/*
 * Copyright 2004 Dovetailed Technologies, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
-->
<%@page import="com.dovetail.jzos.*"%>
<html>
	<head>
		<META HTTP-EQUIV="CACHE-CONTROL" CONTENT="NO-CACHE"/>
		<META HTTP-EQUIV="EXPIRES" CONTENT="0"/>
		<META HTTP-EQUIV="PRAGMAS" CONTENT="NO-CACHE"/>
		<title>SAF Security Tester</title>
	</head>
	<body>
		<center>
		<h1>SAF Security Tester</h1>
<%	
	String userid = request.getParameter("userid");
	String safclass = request.getParameter("safclass");
	String safentity = request.getParameter("safentity");
	boolean submitted = request.getParameter("submit") != null;
	String message = "";
	boolean checkFailed = false;
	
	if (userid == null) {
		try {
			userid = ZUtil.getCurrentUser();
		} catch (RcException rce) {
			System.err.println("An error occurred attempting to get current user: " + rce.getMessage());
			userid = "";
		}
	}
	userid = userid.trim().toUpperCase();

	if (safclass == null) {
		safclass = "EJBROLE";
	}
	safclass = safclass.trim().toUpperCase();

	if (safentity == null) {
		safentity = "";
	}
	safentity = safentity.trim();

	int accessLevel = ZUtil.RESOURCE_READ;
	String sAccessLevel = request.getParameter("accessLevel");
	if (sAccessLevel != null ) {
		if (sAccessLevel.equals("update")) {
		accessLevel = ZUtil.RESOURCE_UPDATE;
		} else if (sAccessLevel.equals("alter")) {
		accessLevel = ZUtil.RESOURCE_ALTER;
		} else if (sAccessLevel.equals("control")) {
		accessLevel = ZUtil.RESOURCE_CONTROL;
		}
	}
	System.out.println("SafTest:  userid=" + userid +
						" safClass=" + safclass +
						" safEntity=" + safentity +
						" accessLevel=" + sAccessLevel + " (" + accessLevel + ")");
	if (submitted ) {
		try {
			ZUtil.hasPermission(userid, safclass, safentity, accessLevel);
			message = "Security check passed";
			checkFailed = false;
		} catch (ErrnoException ee) {
		    message = "Security check failed, msg= " + ee.getMessage();
		    checkFailed = true;
		}
	}

%>
		<form action="SafTest.jsp" method="post">
			<table cellpadding=4 cellspacing=2 border=0>

			<tr>
			 	<th align="right">Userid:</th>
				<td><input type="text" name="userid" size="10" maxLength="8" value="<%= userid %>"/></td>
			</tr>
			
			<tr>
				<th align="right">SAF Class:</th>
				<td><input type="text" name="safclass" size="10" maxLength="8" value="<%= safclass %>"/></td>
			</tr>

			<tr>
				<th align="right">SAF Entity:</th>
				<td><input type="text" name="safentity" size="46" value="<%= safentity %>"/></td>
			</tr>
			<tr>
				<th/>
				<td>(Entity names are case sensitive)</td>
			</tr>
			
			<tr>
				<th align="right">Access:</th>
				<td>
				<select name="accessLevel">
					<option value="read" 
						<%=(accessLevel == ZUtil.RESOURCE_READ ? "selected=\"selected\"" : "")%> 
						> Read
					</option>
					<option value="update" 
						<%=(accessLevel == ZUtil.RESOURCE_UPDATE ? "selected=\"selected\"" : "")%> 
						> Update
					</option>
					<option value="alter" 
						<%=(accessLevel == ZUtil.RESOURCE_ALTER ? "selected=\"selected\"" : "")%> 
						> Alter
					</option>
					<option value="control" 
						<%=(accessLevel == ZUtil.RESOURCE_CONTROL ? "selected=\"selected\"" : "")%> 
						> Control
					</option>
				</select>
				</td>
			</tr>
			
			<tr>	
				<th/>
				<td><input type="submit" name="submit" value="Check Permission"/> </td>
			</tr>
			</table>
		</form> 
		<br/> 
		<strong><%= message %></strong>
		<% if (checkFailed) { %>
			<p>For more information about the ERRNO and ERRNO2 (errnojr) codes, see the following IBM publication:
			<br>
			<a href="http://publibz.boulder.ibm.com/epubs/pdf/bpxza800.pdf">z/OS V1R1.0 UNIX System Services Messages and Codes - SA22-7807-00 (PDF)</a>
			<p>In this document, ERRNO is a ReturnCode and the last 4 digits of ERRNO2 is the ReasonCode</p>
		<% } %>

		</center>
			
	</body>
</html>