/*
 * Copyright 2004 Dovetailed Technologies, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.dovetail.jzos.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.dovetail.jzos.RcException;
import com.dovetail.jzos.ZUtil;

/**
 * Servlet that extracts information about JZOS and displays in the response
 * document.
 */
public class JzosEnvironmentInfoServlet extends HttpServlet {

	private static final long serialVersionUID = 1L;

	protected void service(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
	    String jobname = ZUtil.getCurrentJobname();
	    String currentUser = null;
	    try {
	        currentUser = ZUtil.getCurrentUser();
	    } catch (RcException rce) {
	        currentUser = rce.getMessage();
	    }
		PrintWriter writer = response.getWriter();
		writer.write("<html>");
		writer.write("<h1>JZOS - Environment Information</h1>");
		writer.write("<h2>Current MVS User=" + currentUser + "</h2>");
		writer.write("<h2>Current Jobname=" + jobname + "</h2>");
		writer.write("<h2>PATH=" + ZUtil.getEnv("PATH") + "</h2>");
		writer.write("<h2>JAVA_HOME=" + ZUtil.getEnv("JAVA_HOME") + "</h2>");
		writer.write("<h2>JZOS_HOME=" + ZUtil.getEnv("JZOS_HOME") + "</h2>");
		for (Iterator iter = System.getProperties().entrySet().iterator(); iter.hasNext(); ) {
			Map.Entry e = (Map.Entry)iter.next();
			writer.write("<h2> -D" + e.getKey() + "=" +e.getValue() + "</h2>");
		}
		writer.write("</html>");
		writer.close();
	}

}
