/*
 * Copyright 2004 Dovetailed Technologies, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.dovetail.jzos.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

/**
 * Servlet that can be used to test Tomcat's JDBC configuration.
 */
public class JdbcServlet extends HttpServlet {

	private static final long serialVersionUID = 1L;

	protected void service(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		PrintWriter writer = response.getWriter();
		writer.write("<html><h1>Testing JDBC...</h1>");
		try{
			Context myContext = new InitialContext();
			Context envContext = (Context)myContext.lookup("java:comp/env");
			DataSource myDataSource = (DataSource)envContext.lookup("jdbc/db2");
			Connection con = myDataSource.getConnection();
			// Create the Statement
			Statement stmt = con.createStatement();
			writer.write("<p>**** JDBC Statement Created");

			// Execute a Query and generate a ResultSet instance
			// The Query is a Select from SYSIBM.SYSTABLES.
			// (Try SYS.SYSTABLES in case running under Derby/Cloudscape)
			ResultSet rs;
			try {
				rs = stmt.executeQuery("SELECT count(*) FROM SYSIBM.SYSTABLES");
			} catch(Exception e) {
				rs = stmt.executeQuery("SELECT count(*) FROM SYS.SYSTABLES");
			}
			writer.write("<p>**** JDBC Result Set Created");

			rs.next();
			
			writer.write("<p>**** Number of SYSTABLES = " + rs.getInt(1));

			// Close the resultset
			rs.close();
			// Close the statement
			stmt.close();
			writer.write("<p>**** JDBC Statement Closed");

			// Assure connection is on a unit of work boundary prior to close
			// (more important when autoCommit is false, but provided as example)
			con.rollback();

			// Close the connection
			con.close();
			writer.write("<p>**** JDBC Disconnect");
			writer.write("<h2>Test Successful!</h2>");

		} catch(NamingException ne) {
			writer.write("<h2>NamingException:</h2>");
			writer.write("<p>" + ne.toString());
		} catch(SQLException sqle) {
				writer.write("<h2>SQLException:</h2>");
				writer.write("<p>" + sqle.toString());
		}
		writer.write("</html>");
		writer.close();
	}
}
