package com.dovetail.jzos.sample;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Properties;

/**
 * Connect to DB2 using a type-4 Universal driver.
 * Prompts for connection / query parameters.
 * 
 */
public class HelloDB2 {

	public static void main(String[] args) throws Exception {

		Properties parms = promptForParms();
		HelloDB2 instance = new HelloDB2();
		instance.run(parms);
	}

	static Properties promptForParms() {

		BufferedReader in = new BufferedReader(new InputStreamReader(
				System.in));
		
		Properties parms = new Properties();
		parms.put("driver", prompt(in, "jdbc driver name",
				"com.ibm.db2.jcc.DB2Driver"));
		parms.put("server", prompt(in, "server host name", "127.0.0.1"));
		parms.put("port", prompt(in, "port", "446"));
		parms.put("databaseName", prompt(in, "databaseName", ""));
		parms.put("userid", prompt(in, "userid", ""));
		parms.put("password", prompt(in, "password", ""));
		parms.put("query", prompt(in, "query", "select * from sysibm.systables"));
		parms.put("maxrows", prompt(in, "maxrows", "100"));
		return parms;
	}

	static String prompt(BufferedReader in, String name, String defaultValue) {
		try {
			String str = null;
			System.out.print("Enter " + name + " [" + defaultValue + "] :");
			str = in.readLine();
			if (str != null && str.trim().length() > 0) {
				str = str.trim();
				System.out.println("\n - " + name + "=" + str);
				return str;
			}
		} catch (IOException ignore) {
		}

		return defaultValue;
	}

	public void run(Properties parms) throws Exception {
		Class.forName(parms.getProperty("driver"));

		StringBuffer url = new StringBuffer();
		url.append("jdbc:db2://");
		url.append(parms.getProperty("server"));
		if (parms.getProperty("port").length() > 0) {
			url.append(":");
			url.append(parms.getProperty("port"));
		}
		if (parms.getProperty("databaseName").length() > 0) {
			url.append("/");
			url.append(parms.getProperty("databaseName"));
		}
		System.out.println("Opening connection for URL: \"" + url.toString()
				+ "\" ...");

		Connection db2Conn = DriverManager.getConnection(url.toString(), parms
				.getProperty("userid"), parms.getProperty("password"));
		System.out.println("Connection was opened");

		Statement st = null;
		ResultSet resultSet = null;
		try {
			st = db2Conn.createStatement();
			
			System.out.println("Executing query: " + parms.getProperty("query"));
			resultSet = st.executeQuery(parms.getProperty("query"));
			
			ResultSetMetaData md = resultSet.getMetaData();
			int colcount = md.getColumnCount();
			int rownum = 1;
			int maxrows = Integer.parseInt(parms.getProperty("maxrows"));
			while (resultSet.next() && rownum <= maxrows) {
				System.out.println("\n--- Result Row #" + rownum);
				for (int col = 1; col <= colcount; col++) {
					System.out.println("  " + md.getColumnName(col) + " - "
							+ resultSet.getObject(col));
				}
				rownum++;
			}
		} finally {
			if (resultSet != null)
				resultSet.close();
			if (st != null)
				st.close();
			db2Conn.close();
		}
	}
}
