package com.dovetail.jzos.sample;
import com.dovetail.jzos.ZFile;

/*
 * Copyright 2004 Dovetailed Technologies, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Simple test class that opens a ZFile and prints its attributes
 * 
 * @author Stephen Goetze
 */
public class FileTester {

    private String name;
    private ZFile zfile;
    
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("USAGE: FileTester <filename>");
            return;
        }
        String name = args[0];
        System.out.println("Attempting to retrieve attributes for file: " + name);
        System.out.println(new FileTester(name).getAttributes());
    }

    public FileTester(String name) {
        this.name = name;
    }
    
    public String getAttributes() {
        String attributes = null;
        try {
            if (!ZFile.exists(name)) {
               return name + " does not exist ";
            }
            zfile = new ZFile(name, "r");
	        StringBuffer sb = new StringBuffer("Attributes for file: ");
	        sb.append(zfile.getFilename());
	        sb.append("\n");
    		sb.append("\trecfm=" + zfile.getRecfm() + "\n");
    		sb.append("\tdsorg=" + zfile.getDsorg() + "\n");
    		sb.append("\tvsamType=" + zfile.getVsamType() + "\n");
    		sb.append("\tlrecl=" + zfile.getLrecl() + "\n");
    		sb.append("\tblksize=" + zfile.getBlksize() + "\n");
    		attributes = sb.toString();
        } catch (Exception e) {
            attributes = ("Exception encountered: " + e.toString());
        } finally {
            if (zfile != null) {
                try {
                    zfile.close();
                } catch(Exception e) {
                    //ignore
                }
            }
        }
        return attributes;
    }
}
