/*
* %Z%%W% %I%
*
===========================================================================
* Licensed Materials - Property of IBM
* "Restricted Materials of IBM"
* (C) Copyright IBM Corp. 2005. All Rights Reserved
*
===========================================================================
*/
package com.dovetail.jzos.sample;

import com.dovetail.jzos.ZFile;

/**
 * Sample program that prints an EBCDIC MVS dataset pointed to by //SYSIN DD
 * to System.out (stdout).
 * The dataset is opened using the ZFile class in record mode.
 * Note that "noseek" is used so that the file is opened in sequential 
 * mode, which dramatically increases I/O performance.
 * 
 * @see com.dovetail.jzos.ZFile
 */
public class ZFilePrint {
    public static void main(String[] args) throws Exception {
        ZFile zFile = new ZFile("//DD:INPUT", "rb,type=record,noseek");
        try {
            byte[] recBuf = new byte[zFile.getLrecl()];
            int nRead;
            while((nRead = zFile.read(recBuf)) > 0) {
            	String line = new String(recBuf,0,nRead, 
            							ZFile.DEFAULT_EBCDIC_CODE_PAGE);
                System.out.println(line);
            };
        } finally {
           zFile.close();
        }
    }
}
