/*
* %Z%%W% %I%
*
===========================================================================
* Licensed Materials - Property of IBM
* "Restricted Materials of IBM"
* (C) Copyright IBM Corp. 2005. All Rights Reserved
*
===========================================================================
*/
package com.dovetail.jzos.sample;

import com.dovetail.jzos.ZFile;

/**
 * Sample program that uses the ZFile class to copy an MVS dataset in 
 * record mode from DD INPUT to DD OUTPUT.
 * Note that "noseek" is used so that the file is opened in sequential 
 * mode, which dramatically increases I/O performance.
 * 
 * @see com.dovetail.jzos.ZFile
 */
public class ZFileCopy {
    public static void main(String[] args) throws Exception {
        ZFile zFileIn = new ZFile("//DD:INPUT", "rb,type=record,noseek");
        ZFile zFileOut = new ZFile("//DD:OUTPUT", "wb,type=record,noseek");
        long count = 0;
        try {
            byte[] recBuf = new byte[zFileIn.getLrecl()];
            int nRead;
            while((nRead = zFileIn.read(recBuf)) > 0) {
            	zFileOut.write(recBuf, 0, nRead);
            	count++;
            };
            System.out.println("ZFileCopy: " + count + " records copied");
        } finally {
           zFileIn.close();
           zFileOut.close();
        }
    }
}
