/*
* %Z%%W% %I%
*
===========================================================================
* Licensed Materials - Property of IBM
* "Restricted Materials of IBM"
* (C) Copyright IBM Corp. 2005. All Rights Reserved
*
===========================================================================
*/
package com.dovetail.jzos;

import java.io.IOException;

/**
 * A customized IOException to carry detailed native file error information.
 * If errno was set, the result of strerror(errno) is available in errnoMsg.
 * If the native file is not an HFS file, additional information from the amrc
 * structure is provided.
 */
public class ZFileException extends IOException {

    private String fileName;
    private String errnoMsg;
    private int errno;
    private int errno2;
    private int lastOp;
    private int abendCode;
    private int abendRc;
    
	public ZFileException(String fileName, String msg, String errnoMsg, 
	        int errno, int errno2, int lastOp, int abendCode, int abendRc) {
		super(msg);
		this.fileName = fileName;
		this.errnoMsg = errnoMsg;
		this.errno = errno;
		this.errno2 = errno2;
		this.lastOp = lastOp;
		this.abendCode = abendCode;
		this.abendRc = abendRc;
	}

    public String getMessage() {
        StringBuffer sb = new StringBuffer(fileName);
        sb.append(": ");
        sb.append(super.getMessage());
        if (errno != 0) {
            sb.append(" - ");
            sb.append(errnoMsg);
            sb.append(" ERRNO=");
            sb.append(errno);
            sb.append(" ERRNO2=0x");
            sb.append(Integer.toHexString(errno2));
        }
        if (lastOp != -1) {
            sb.append(" LAST_OP=");
            sb.append(lastOp);
            sb.append(" ABEND_CODE=0x");
            sb.append(Integer.toHexString(abendCode));
            sb.append(" ABEND_RC=");
            sb.append(abendRc);
        }
        return sb.toString();
    }

    public int getAbendCode() {
        return abendCode;
    }

    public int getAbendRc() {
        return abendRc;
    }

    public int getErrno() {
        return errno;
    }

    public int getErrno2() {
        return errno2;
    }

    public String getErrnoMsg() {
        return errnoMsg;
    }

    public String getFileName() {
        return fileName;
    }

    public int getLastOp() {
        return lastOp;
    }
}
