/*
* %Z%%W% %I%
*
===========================================================================
* Licensed Materials - Property of IBM
* "Restricted Materials of IBM"
* (C) Copyright IBM Corp. 2005. All Rights Reserved
*
===========================================================================
*/
package com.dovetail.jzos;

/**
 * Exception class that holds a return code and message resulting
 * from a native call error.
 */
public class RcException extends Exception {

    private int rc;
    
    public RcException(String msg, int rc) {
        super(msg);
        this.rc = rc;
    }
    
    public String getMessage() {
        return super.getMessage() + " RC=" + rc + " (0x" + Integer.toHexString(rc) + ")";
    }

    public int getRc() {
        return rc;
    }
}
