/*
* %Z%%W% %I%
*
===========================================================================
* Licensed Materials - Property of IBM
* "Restricted Materials of IBM"
* (C) Copyright IBM Corp. 2005. All Rights Reserved
*
===========================================================================
*/
package com.dovetail.jzos;

/**
 * Implement this interface to control how MVS operator commands are handled.
 * The implementing class must be registered with a call to
 * {@link ZUtil#setMvsCommandCallback(MvsCommandCallback) setMvsCommandCallback}
 * <p>
 * Note that MVS STOP commands are not handled via this interface; they always result
 * in a call to System.exit().
 */
public interface MvsCommandCallback {
    /**
     * Handle an MVS MODIFY (F) command.
     * @param modifyCommand	the modify command supplied by the operator
     */
	public void handleModify(String modifyCommand);
    /**
     * Handle an MVS START (S) command.  Note that the START command will have
     * already been issued by the time this callback is registered.  Therefore, this
     * method will fire immediately upon registration.  This method can be used to
     * obtain the start parameters.
     * @param startParameters the start parameters supplied by the operator
     */
	public void handleStart(String startParameters);
}
