/*
* %Z%%W% %I%
*
===========================================================================
* Licensed Materials - Property of IBM
* "Restricted Materials of IBM"
* (C) Copyright IBM Corp. 2005. All Rights Reserved
*
===========================================================================
*/
package com.dovetail.jzos;

/**
 * Exception class that holds the errno and errno2 information resulting
 * from a native call error.
 */
public class ErrnoException extends Exception {

    private int errno;
    private int errno2;

    public ErrnoException(String errnoMsg, int errno, int errno2) {
        super(errnoMsg);
        this.errno = errno;
        this.errno2 = errno2;
    }
    
    public String getMessage() {
        return super.getMessage() + " ERRNO=" + errno + " ERRNO2=" + Integer.toHexString(errno2);
    }

    public int getErrno() {
        return errno;
    }

    public int getErrno2() {
        return errno2;
    }
}
