/*
 * Decompiled with CFR 0.152.
 */
package com.dovetail.jzos;

import com.dovetail.jzos.ErrnoException;
import com.dovetail.jzos.MvsCommandCallback;
import com.dovetail.jzos.RcException;
import com.dovetail.jzos.TranscodingPrintStream;
import com.dovetail.jzos.ZFile;
import com.dovetail.jzos.ZFileException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ZUtil {
    public static final int LOG_ERR = 0;
    public static final int LOG_WARN = 1;
    public static final int LOG_NOTICE = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_DEBUG = 4;
    public static final int LOG_TRACE = 5;
    private static final String loggingLevels = "EWNIDT";
    public static final int RESOURCE_READ = 1;
    public static final int RESOURCE_UPDATE = 2;
    public static final int RESOURCE_CONTROL = 3;
    public static final int RESOURCE_ALTER = 4;
    private static String defaultPlatformEncoding;
    private static MvsCommandThread mvsCommandThread;

    static {
        if (System.getProperty("java.version").startsWith("1.3")) {
            System.loadLibrary("jzos13");
        } else if (System.getProperty("java.version").startsWith("1.4")) {
            System.loadLibrary("jzos14");
        } else {
            System.loadLibrary("jzos50");
        }
        String logLevel = System.getProperty("jzos.logging");
        if (logLevel != null) {
            int level = loggingLevels.indexOf(logLevel.toUpperCase().charAt(0));
            if (level == -1) {
                level = 3;
            }
            ZUtil.setLoggingLevel(level);
        }
        defaultPlatformEncoding = ZFile.DEFAULT_EBCDIC_CODE_PAGE;
    }

    private ZUtil() {
    }

    public static void establishMvsCommandWaiter() {
        mvsCommandThread = new MvsCommandThread();
        mvsCommandThread.setDaemon(true);
        mvsCommandThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (mvsCommandThread.isAlive() && mvsCommandThread.hCancellationECB != 0L) {
                    ZUtil.cancelWaitForMvsCommand(mvsCommandThread.hCancellationECB);
                }
            }
        });
    }

    public static void setMvsCommandCallback(MvsCommandCallback callback) {
        if (mvsCommandThread == null || !mvsCommandThread.isAlive()) {
            throw new IllegalStateException("No mvsCallbackThread active - callback cannot be set");
        }
        mvsCommandThread.setCallback(callback);
    }

    public static String getDefaultOutputEncoding() {
        return ZUtil.getDefaultPlatformEncoding();
    }

    public static void setDefaultOutputEncoding(String encoding) {
        ZUtil.setDefaultPlatformEncoding(encoding);
    }

    public static String getDefaultPlatformEncoding() {
        return defaultPlatformEncoding;
    }

    public static void setDefaultPlatformEncoding(String encoding) {
        defaultPlatformEncoding = encoding;
    }

    public static native String getEnv(String var0);

    public static native void setLoggingLevel(int var0);

    private static native String getJobname();

    public static String getCurrentJobname() {
        return ZUtil.getJobname().trim();
    }

    private static native String getUsername() throws RcException;

    public static String getCurrentUser() throws RcException {
        return ZUtil.getUsername().trim();
    }

    public static String getJavaVersionInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("java version \"");
        sb.append(System.getProperty("java.version"));
        sb.append("\"\n");
        sb.append(System.getProperty("java.runtime.name"));
        sb.append(" (build ");
        sb.append(System.getProperty("java.runtime.version"));
        sb.append(")\n");
        sb.append(System.getProperty("java.vm.name"));
        sb.append(" (build ");
        sb.append(System.getProperty("java.vm.version"));
        sb.append(", ");
        sb.append(System.getProperty("java.vm.info"));
        sb.append(")");
        return sb.toString();
    }

    public static native void authenticate(String var0, String var1) throws ErrnoException;

    public static native void hasPermission(String var0, String var1, String var2, int var3) throws ErrnoException;

    public static int wto(String message, int routeCode, int descriptor) {
        if (message.length() <= 125) {
            return ZUtil.WTO(message, routeCode, descriptor, ZUtil.getDefaultPlatformEncoding());
        }
        return ZUtil.MLWTO(ZUtil.formatLines(message, 70, "  "), routeCode, descriptor, ZUtil.getDefaultPlatformEncoding());
    }

    public static int wto(String[] lines, int routeCode, int descriptor) {
        return ZUtil.MLWTO(lines, routeCode, descriptor, ZUtil.getDefaultPlatformEncoding());
    }

    static String[] formatLines(String longString, int maxLength, String indent) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        StringTokenizer strTok = new StringTokenizer(longString);
        while (strTok.hasMoreTokens()) {
            String tok = strTok.nextToken();
            if (sb.length() + tok.length() > maxLength) {
                lines.add(sb.toString());
                sb = new StringBuffer(indent);
            }
            if (tok.length() > maxLength) {
                System.err.println("'" + tok + "' is too long for WTO line.  It will be truncated.");
                sb.append(tok.substring(0, maxLength - sb.length()));
            } else {
                sb.append(tok);
            }
            if (sb.length() >= maxLength) continue;
            sb.append(" ");
        }
        if (sb.length() > 0) {
            lines.add(sb.toString());
        }
        return lines.toArray(new String[lines.size()]);
    }

    private static native int MLWTO(String[] var0, int var1, int var2, String var3);

    private static native int WTO(String var0, int var1, int var2, String var3);

    public static void redirectStandardStreams() throws Exception {
        ZUtil.redirectStandardStreams(ZUtil.getDefaultPlatformEncoding(), true);
    }

    public static boolean redirectStandardStreams(String requestedEncoding, final boolean enableTranscoding) throws Exception {
        String effectiveEncoding = requestedEncoding;
        try {
            new String(new byte[1], requestedEncoding);
            ZUtil.setDefaultPlatformEncoding(requestedEncoding);
        }
        catch (UnsupportedEncodingException uee) {
            effectiveEncoding = ZUtil.getDefaultPlatformEncoding();
        }
        final String enc = effectiveEncoding;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ZFileException {
                    ZFile systemErrFile = new ZFile("DD:STDERR", "w");
                    System.setErr(ZUtil.newEncodedPrintStream(systemErrFile.getOutputStream(), false, enc, enableTranscoding));
                    ZFile systemOutFile = new ZFile("DD:STDOUT", "w");
                    System.setOut(ZUtil.newEncodedPrintStream(systemOutFile.getOutputStream(), false, enc, enableTranscoding));
                    try {
                        ZFile systemInFile = new ZFile("DD:STDIN", "r");
                        System.setIn(systemInFile.getInputStream());
                    }
                    catch (Exception e) {
                        System.setIn(new InputStream(this){
                            final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public int read() throws IOException {
                                return -1;
                            }
                        });
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        return effectiveEncoding.equals(requestedEncoding);
    }

    public static PrintStream newEncodedPrintStream(OutputStream os, boolean autoFlush) {
        return ZUtil.newEncodedPrintStream(os, autoFlush, ZUtil.getDefaultPlatformEncoding());
    }

    public static PrintStream newEncodedPrintStream(OutputStream os, boolean autoFlush, String encoding) {
        return ZUtil.newEncodedPrintStream(os, autoFlush, encoding, true);
    }

    public static PrintStream newEncodedPrintStream(OutputStream os, boolean autoFlush, String encoding, boolean enable) {
        TranscodingPrintStream tps = new TranscodingPrintStream(os, autoFlush, encoding, enable);
        return tps;
    }

    static native void setObjectField(Object var0, Object var1, String var2, String var3);

    private static native String waitForMvsCommand(Object var0);

    private static native void cancelWaitForMvsCommand(long var0);

    private static class MvsCommandThread
    extends Thread {
        private long hCancellationECB;
        private MvsCommandCallback callback;
        private String startParameters;

        MvsCommandThread() {
        }

        public void setCallback(MvsCommandCallback callback) {
            this.callback = callback;
            if (this.startParameters != null) {
                callback.handleStart(this.startParameters);
            }
        }

        public void run() {
            String commandString;
            block5: while ((commandString = ZUtil.waitForMvsCommand(this)) != null) {
                char cmd = commandString.charAt(0);
                commandString = commandString.substring(1);
                switch (cmd) {
                    case 'P': {
                        ZUtil.wto("JZOS - MVS STOP command received", 32, 16384);
                        this.hCancellationECB = 0L;
                        System.exit(0);
                        continue block5;
                    }
                    case 'S': {
                        ZUtil.wto("JZOS - MVS START command received with parameters: " + commandString, 32, 16384);
                        this.startParameters = commandString;
                        if (this.callback == null) continue block5;
                        this.callback.handleStart(commandString);
                        continue block5;
                    }
                    case 'F': {
                        ZUtil.wto("JZOS - MVS MODIFY command received: " + commandString, 32, 16384);
                        if (this.callback == null) continue block5;
                        this.callback.handleModify(commandString);
                        continue block5;
                    }
                }
                ZUtil.wto("JZOS - MVS <Unknown> command received", 32, 16384);
            }
            return;
        }
    }
}

