/*
 * Decompiled with CFR 0.152.
 */
package com.dovetail.jzos;

import java.io.IOException;

public class ZFileException
extends IOException {
    private String fileName;
    private String errnoMsg;
    private int errno;
    private int errno2;
    private int lastOp;
    private int abendCode;
    private int abendRc;

    public ZFileException(String fileName, String msg, String errnoMsg, int errno, int errno2, int lastOp, int abendCode, int abendRc) {
        super(msg);
        this.fileName = fileName;
        this.errnoMsg = errnoMsg;
        this.errno = errno;
        this.errno2 = errno2;
        this.lastOp = lastOp;
        this.abendCode = abendCode;
        this.abendRc = abendRc;
    }

    public String getMessage() {
        StringBuffer sb = new StringBuffer(this.fileName);
        sb.append(": ");
        sb.append(super.getMessage());
        if (this.errno != 0) {
            sb.append(" - ");
            sb.append(this.errnoMsg);
            sb.append(" ERRNO=");
            sb.append(this.errno);
            sb.append(" ERRNO2=0x");
            sb.append(Integer.toHexString(this.errno2));
        }
        if (this.lastOp != -1) {
            sb.append(" LAST_OP=");
            sb.append(this.lastOp);
            sb.append(" ABEND_CODE=0x");
            sb.append(Integer.toHexString(this.abendCode));
            sb.append(" ABEND_RC=");
            sb.append(this.abendRc);
        }
        return sb.toString();
    }

    public int getAbendCode() {
        return this.abendCode;
    }

    public int getAbendRc() {
        return this.abendRc;
    }

    public int getErrno() {
        return this.errno;
    }

    public int getErrno2() {
        return this.errno2;
    }

    public String getErrnoMsg() {
        return this.errnoMsg;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLastOp() {
        return this.lastOp;
    }
}

