/*
 * Decompiled with CFR 0.152.
 */
package com.dovetail.jzos;

import com.dovetail.jzos.ByteUtil;
import com.dovetail.jzos.JzosPermission;
import com.dovetail.jzos.RcException;
import com.dovetail.jzos.ZFileException;
import com.dovetail.jzos.ZUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ZFile {
    public static String DEFAULT_EBCDIC_CODE_PAGE;
    public static String DEFAULT_ASCII_CODE_PAGE;
    public static int LOCATE_RBA_EQ;
    public static int LOCATE_KEY_FIRST;
    public static int LOCATE_KEY_LAST;
    public static int LOCATE_KEY_EQ;
    public static int LOCATE_KEY_EQ_BWD;
    public static int LOCATE_KEY_GE;
    public static int LOCATE_RBA_EQ_BWD;
    public static int SEEK_SET;
    public static int SEEK_CUR;
    public static int SEEK_END;
    private String name;
    private String options;
    private long hFileInfo;

    static {
        if (System.getProperty("java.version").startsWith("1.3")) {
            System.loadLibrary("jzos13");
        } else if (System.getProperty("java.version").startsWith("1.4")) {
            System.loadLibrary("jzos14");
        } else {
            System.loadLibrary("jzos50");
        }
        DEFAULT_EBCDIC_CODE_PAGE = "Cp1047";
        DEFAULT_ASCII_CODE_PAGE = "ISO8859-1";
        LOCATE_RBA_EQ = 0;
        LOCATE_KEY_FIRST = 1;
        LOCATE_KEY_LAST = 2;
        LOCATE_KEY_EQ = 3;
        LOCATE_KEY_EQ_BWD = 4;
        LOCATE_KEY_GE = 5;
        LOCATE_RBA_EQ_BWD = 6;
        SEEK_SET = 0;
        SEEK_CUR = 1;
        SEEK_END = 2;
    }

    public static native void bpxwdyn(String var0) throws RcException;

    public static void deleteDatatset(String datasetName) throws ZFileException {
        if (datasetName == null) {
            throw new NullPointerException("dataset name to delete may not be null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JzosPermission("zfile.all"));
        }
        ZFile.fremove("//'" + ZFile.getFullyQualifiedDSN(datasetName) + "'");
    }

    public static void renameDatatset(String oldDatasetName, String newDatasetName) throws ZFileException {
        if (oldDatasetName == null || newDatasetName == null) {
            throw new NullPointerException("dataset names to rename may not be null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JzosPermission("zfile.all"));
        }
        ZFile.frename("//'" + ZFile.getFullyQualifiedDSN(oldDatasetName) + "'", "//'" + ZFile.getFullyQualifiedDSN(newDatasetName) + "'");
    }

    public static native boolean ddExists(String var0) throws ZFileException;

    public static boolean dsExists(String dsn) throws ZFileException {
        String[] volumes = ZFile.getVolumeList(dsn = ZFile.getFullyQualifiedDSN(dsn));
        if (volumes.length == 0) {
            return false;
        }
        String volume = volumes[0];
        if (volume.equals("MIGRAT")) {
            return true;
        }
        return ZFile.readDSCB(dsn, volume, new byte[140]);
    }

    public static native boolean hfsExists(String var0) throws ZFileException;

    public static boolean exists(String filename) throws ZFileException {
        String upperFilename = filename.toUpperCase();
        if (upperFilename.startsWith("//DD:") || upperFilename.startsWith("DD:")) {
            String ddname = filename.substring(filename.indexOf(58) + 1).trim();
            return ZFile.ddExists(ddname);
        }
        if (filename.startsWith("//") && !filename.startsWith("///")) {
            String dsn = filename.substring(2);
            return ZFile.dsExists(dsn);
        }
        return ZFile.hfsExists(filename);
    }

    public static String getFullyQualifiedDSN(String dsn) {
        if (dsn.charAt(0) == '\'') {
            dsn = dsn.substring(1, dsn.length() - 1);
        } else {
            try {
                dsn = String.valueOf(ZUtil.getCurrentUser()) + "." + dsn;
            }
            catch (RcException rc) {
                throw new RuntimeException("Could not retrieve MVS_USERID " + rc.toString());
            }
        }
        return dsn;
    }

    public static String[] getVolumeList(String dsn) throws ZFileException {
        byte[] volBuf = new byte[265];
        if (ZFile.locateDSN(dsn, volBuf)) {
            int volCount = ByteUtil.bytesAsInt(volBuf, 0, 2);
            String[] volumes = new String[volCount];
            int j = 2;
            int i = 0;
            while (i < volCount) {
                try {
                    String volser = new String(volBuf, j + 4, 6, "Cp1047");
                    volumes[i] = volser.trim();
                }
                catch (UnsupportedEncodingException uce) {
                    throw new RuntimeException(uce.toString());
                }
                j += 12;
                ++i;
            }
            return volumes;
        }
        return new String[0];
    }

    public static native boolean locateDSN(String var0, byte[] var1) throws ZFileException;

    public static native boolean readDSCB(String var0, String var1, byte[] var2) throws ZFileException;

    private static native void fremove(String var0) throws ZFileException;

    private static native void frename(String var0, String var1) throws ZFileException;

    public ZFile(String name, String options) throws ZFileException {
        this.name = name;
        this.options = options;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JzosPermission("zfile.all"));
        }
        this.hFileInfo = this.fopen(name, options);
    }

    public int getBlksize() throws ZFileException {
        return this.getBlksize(this.getHFileInfo());
    }

    public long getByteCount() throws ZFileException {
        return this.getByteCount(this.getHFileInfo());
    }

    public String getDsorg() throws ZFileException {
        return this.getDsorg(this.getHFileInfo());
    }

    public byte[] getPos() throws ZFileException {
        return this.fgetpos(this.getHFileInfo());
    }

    public String getFilename() {
        return this.name;
    }

    public String getOptions() {
        return this.options;
    }

    public InputStream getInputStream() {
        return new InputStream(){

            public void close() throws IOException {
                ZFile.this.close();
            }

            public int read() throws IOException {
                byte[] buf = new byte[1];
                int nRead = ZFile.this.read(buf);
                if (nRead < 0) {
                    return nRead;
                }
                return buf[0];
            }

            public int read(byte[] buf, int off, int len) throws IOException {
                return ZFile.this.read(buf, off, len);
            }

            public int read(byte[] buf) throws IOException {
                return ZFile.this.read(buf);
            }
        };
    }

    public int getLrecl() throws ZFileException {
        return this.getLrecl(this.getHFileInfo());
    }

    public OutputStream getOutputStream() {
        return new OutputStream(){

            public void close() throws IOException {
                ZFile.this.close();
            }

            public void flush() throws IOException {
                ZFile.this.flush();
            }

            public void write(int b) throws IOException {
                byte[] buf = new byte[]{(byte)b};
                ZFile.this.write(buf);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                ZFile.this.write(b, off, len);
            }

            public void write(byte[] b) throws IOException {
                ZFile.this.write(b);
            }
        };
    }

    public String getRecfm() throws ZFileException {
        return this.getRecfm(this.getHFileInfo());
    }

    public long getRecordCount() throws ZFileException {
        return this.getRecordCount(this.getHFileInfo());
    }

    public String getVsamType() throws ZFileException {
        return this.getVsamType(this.getHFileInfo());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws ZFileException {
        try {
            this.fclose(this.getHFileInfo());
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.hFileInfo = 0L;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.hFileInfo = 0L;
            return;
        }
    }

    public void flush() throws ZFileException {
        this.fflush(this.getHFileInfo());
    }

    public void locate(int recordNumber, int options) throws ZFileException {
        this.locate(ByteUtil.intAsBytes(recordNumber), options);
    }

    public void locate(byte[] key, int options) throws ZFileException {
        this.flocate(this.getHFileInfo(), key, options);
    }

    public int read(byte[] buf) throws ZFileException {
        return this.fread(this.getHFileInfo(), buf, 0, buf.length);
    }

    public int read(byte[] buf, int offset, int len) throws ZFileException {
        return this.fread(this.getHFileInfo(), buf, offset, len);
    }

    public void reopen(String options) throws ZFileException {
        this.freopen(this.getHFileInfo(), options);
    }

    public void rewind() throws ZFileException {
        this.rewind(this.getHFileInfo());
    }

    public void seek(long offset, int origin) throws ZFileException {
        this.fseeko(this.getHFileInfo(), offset, origin);
    }

    public void setPos(byte[] position) throws ZFileException {
        this.fsetpos(this.getHFileInfo(), position);
    }

    public long tell() throws ZFileException {
        return this.ftello(this.getHFileInfo());
    }

    public int update(byte[] buf, int size) throws ZFileException {
        return this.fupdate(this.getHFileInfo(), buf, size);
    }

    public void delrec() throws ZFileException {
        this.fdelrec(this.getHFileInfo());
    }

    public void write(byte[] buf) throws ZFileException {
        this.fwrite(this.getHFileInfo(), buf, 0, buf.length);
    }

    public void write(byte[] buf, int offset, int len) throws ZFileException {
        this.fwrite(this.getHFileInfo(), buf, offset, len);
    }

    private long getHFileInfo() throws IllegalStateException {
        if (this.hFileInfo == 0L) {
            throw new IllegalStateException("There is no native file information");
        }
        return this.hFileInfo;
    }

    private native void fclose(long var1) throws ZFileException;

    private native void fflush(long var1) throws ZFileException;

    private native byte[] fgetpos(long var1) throws ZFileException;

    private native void flocate(long var1, byte[] var3, int var4) throws ZFileException;

    private native long fopen(String var1, String var2) throws ZFileException;

    private native int fread(long var1, byte[] var3, int var4, int var5) throws ZFileException;

    private native void freopen(long var1, String var3) throws ZFileException;

    private native void rewind(long var1) throws ZFileException;

    private native void fseeko(long var1, long var3, int var5) throws ZFileException;

    private native void fsetpos(long var1, byte[] var3) throws ZFileException;

    private native long ftello(long var1) throws ZFileException;

    private native int fupdate(long var1, byte[] var3, int var4) throws ZFileException;

    private native void fdelrec(long var1) throws ZFileException;

    private native void fwrite(long var1, byte[] var3, int var4, int var5) throws ZFileException;

    private native int getBlksize(long var1) throws ZFileException;

    private native long getByteCount(long var1) throws ZFileException;

    private native String getDsorg(long var1) throws ZFileException;

    private native int getLrecl(long var1) throws ZFileException;

    private native String getRecfm(long var1) throws ZFileException;

    private native long getRecordCount(long var1) throws ZFileException;

    private native String getVsamType(long var1) throws ZFileException;
}

