/*
 * Decompiled with CFR 0.152.
 */
package com.dovetail.jzos;

import com.dovetail.jzos.ZUtil;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class TranscodingPrintStream
extends PrintStream {
    private boolean active = true;
    private byte[] translateTable;
    private byte[] translateBuffer = new byte[8092];

    public TranscodingPrintStream(OutputStream out, boolean autoFlush, String encoding, boolean enable) {
        super(out, autoFlush);
        this.active = enable;
        this.initializeEncoding(out, encoding);
    }

    private void initializeEncoding(OutputStream out, String encoding) {
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter(out, encoding);
            if (this.active) {
                byte[] indentityMap = new byte[256];
                int i = 0;
                while (i < indentityMap.length) {
                    indentityMap[i] = (byte)i;
                    ++i;
                }
                if (new String(indentityMap).equals(new String(indentityMap, encoding))) {
                    this.translateTable = null;
                } else {
                    this.translateTable = new String(indentityMap).getBytes(encoding);
                    if (this.translateTable.length != indentityMap.length) {
                        this.translateTable = null;
                        ZUtil.wto("JZOS - Both the default file.encoding and the encoding " + encoding + " must be single byte encodings; output transcoding is disabled", 32, 16384);
                    }
                }
            }
        }
        catch (UnsupportedEncodingException oee) {
            ZUtil.wto("JZOS - The encoding " + encoding + " is not supported: " + oee.toString(), 32, 16384);
            throw new RuntimeException("The encoding " + encoding + " is not supported: " + oee.toString());
        }
        BufferedWriter bw = new BufferedWriter(osw);
        ZUtil.setObjectField(this, osw, "charOut", "Ljava/io/OutputStreamWriter;");
        ZUtil.setObjectField(this, bw, "textOut", "Ljava/io/BufferedWriter;");
    }

    public void write(int b) {
        if (this.isActive()) {
            super.write(this.translateTable[b & 0xFF] & 0xFF);
        } else {
            super.write(b);
        }
    }

    public void write(byte[] buf, int off, int len) {
        if (this.isActive()) {
            this.writeTranslatedBytes(buf, off, len);
        } else {
            super.write(buf, off, len);
        }
    }

    private synchronized void writeTranslatedBytes(byte[] buf, int off, int len) {
        if (len > this.translateBuffer.length) {
            this.translateBuffer = new byte[len * 5 / 4];
        }
        int i = 0;
        while (i < len) {
            this.translateBuffer[i] = this.translateTable[buf[i + off] & 0xFF];
            ++i;
        }
        super.write(this.translateBuffer, 0, len);
    }

    public boolean isActive() {
        return this.active && this.translateTable != null;
    }
}

