/*
 * Decompiled with CFR 0.152.
 */
package com.dovetail.jzos;

import com.dovetail.jzos.ByteUtil;
import com.dovetail.jzos.ZFile;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PdsDirectory {
    private ZFile directory;

    public PdsDirectory(String pdsName) throws IOException {
        this.directory = new ZFile(pdsName, "rb,recfm=u,type=record,blksize=256");
        if (!this.directory.getDsorg().equals("PDSdir")) {
            throw new IOException("The name " + pdsName + " does not represent a PDS Directory");
        }
    }

    public void close() throws IOException {
        this.directory.close();
    }

    public Iterator iterator() {
        return new PdsDirectoryIterator();
    }

    private class PdsDirectoryIterator
    implements Iterator {
        private byte[] cb = new byte[256];
        int pos;
        private int blen;

        public PdsDirectoryIterator() {
            this.getNextBlock();
        }

        private void getNextBlock() {
            try {
                if (PdsDirectory.this.directory.read(this.cb) == 0) {
                    throw new IllegalStateException("Expecting another directory block, but found none");
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("IOException occurred attempting to read next directory block: " + ioe.getMessage());
            }
            this.blen = ByteUtil.bytesAsInt(this.cb, 0, 2);
            this.pos = 2;
        }

        public boolean hasNext() {
            if (this.pos + 1 >= this.blen) {
                this.getNextBlock();
            }
            int i = this.pos;
            while (i < this.pos + 8) {
                if (this.cb[i] != -1) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            MemberInfo mi = new MemberInfo(this.cb, this.pos);
            this.pos += mi.getSizeInBytes();
            return mi;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class MemberInfo {
        private String name;
        private byte cByte;
        private byte[] userdata;
        private Statistics statistics;

        public MemberInfo(byte[] bytes, int offset) {
            this.name = new String(bytes, offset, 8);
            this.cByte = bytes[offset + 11];
            int userDataLen = (this.cByte & 0x1F) * 2;
            this.userdata = new byte[userDataLen];
            int i = 0;
            while (i < userDataLen) {
                this.userdata[i] = bytes[offset + 12 + i];
                ++i;
            }
            try {
                this.statistics = new Statistics();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        public boolean isAlias() {
            return (this.cByte & 0x80) != 0;
        }

        public int getSizeInBytes() {
            return 12 + this.userdata.length;
        }

        public byte[] getUserData() {
            return this.userdata;
        }

        public Statistics getStatistics() {
            return this.statistics;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.name);
            if (this.statistics != null) {
                sb.append(" ");
                sb.append(this.statistics.toString());
            }
            return sb.toString();
        }

        public class Statistics {
            public int version;
            public int mod;
            public byte flags;
            public Date creationDate;
            public Date modificationDate;
            public int currentLines;
            public int initialLines;
            public int modifiedLines;
            public String userid;

            public Statistics() throws RuntimeException {
                byte[] ud = MemberInfo.this.userdata;
                if (ud.length != 30) {
                    throw new IllegalStateException("Userdata not 30 bytes long");
                }
                this.version = ByteUtil.bytesAsInt(ud, 0, 1);
                this.mod = ByteUtil.bytesAsInt(ud, 1, 1);
                this.flags = ud[2];
                Calendar cal = Calendar.getInstance();
                cal.clear();
                cal.set(1, (int)ByteUtil.unpackLong(ud, 5, 1, false));
                cal.set(6, (int)ByteUtil.unpackLong(ud, 6, 2, true));
                this.creationDate = cal.getTime();
                cal.clear();
                cal.set(1, (int)ByteUtil.unpackLong(ud, 9, 1, false));
                cal.set(6, (int)ByteUtil.unpackLong(ud, 10, 2, true));
                cal.set(11, (int)ByteUtil.unpackLong(ud, 12, 1, false));
                cal.set(12, (int)ByteUtil.unpackLong(ud, 13, 1, false));
                cal.set(13, (int)ByteUtil.unpackLong(ud, 3, 1, false));
                this.modificationDate = cal.getTime();
                this.currentLines = ByteUtil.bytesAsInt(ud, 14, 2);
                this.initialLines = ByteUtil.bytesAsInt(ud, 16, 2);
                this.modifiedLines = ByteUtil.bytesAsInt(ud, 18, 2);
                this.userid = new String(ud, 20, 7);
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                sb.append(this.version);
                sb.append(".");
                sb.append(this.mod);
                sb.append(" Created: ");
                sb.append(this.creationDate);
                sb.append(" Last Modified: ");
                sb.append(this.modificationDate);
                sb.append(" Current Lines: ");
                sb.append(this.currentLines);
                sb.append(" Intial Lines: ");
                sb.append(this.initialLines);
                sb.append(" Modified Lines: ");
                sb.append(this.modifiedLines);
                sb.append(" Userid: ");
                sb.append(this.userid);
                return sb.toString();
            }
        }
    }
}

