/*
 * Decompiled with CFR 0.152.
 */
package com.dovetail.jzos;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class Exec {
    private String command;
    private String[] cmdargs;
    private String[] envp;
    private File dir;
    private Process process;
    boolean completed;
    boolean destroyed;
    BufferedReader outputReader;
    StdErrConsumer stdErrConsumer = new StdErrConsumer();
    Thread stdErrConsumerThread;
    ProcessHealthTimerTask healthTimerTask = new ProcessHealthTimerTask();
    Timer healthTimer = new Timer();

    public Exec(String command) {
        this(command, null, null);
    }

    public Exec(String command, String[] envp) {
        this(command, envp, null);
    }

    public Exec(String command, String[] envp, File dir) {
        this.command = command;
        this.envp = envp;
        this.dir = dir;
    }

    public Exec(String[] cmdargs) {
        this(cmdargs, null, null);
    }

    public Exec(String[] cmdargs, String[] envp) {
        this(cmdargs, envp, null);
    }

    public Exec(String[] cmdargs, String[] envp, File dir) {
        this.cmdargs = cmdargs;
        this.envp = envp;
        this.dir = dir;
    }

    public static void main(String[] args) throws IOException {
        String line;
        Exec exec;
        if (args.length == 0) {
            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("Enter command: ");
            exec = new Exec(stdin.readLine());
        } else {
            exec = new Exec(args);
        }
        exec.run();
        while ((line = exec.readLine()) != null) {
            System.out.println(line);
        }
        System.out.println("Return Code: " + exec.getReturnCode());
        Iterator iter = exec.getErrorLines().iterator();
        while (iter.hasNext()) {
            System.err.println(iter.next());
        }
    }

    public List getErrorLines() {
        return this.stdErrConsumer.getErrorLines();
    }

    public void setMaxErrorLines(int maxErrorLines) {
        this.stdErrConsumer.setMaxLines(maxErrorLines);
    }

    public int getMaxErrorLines() {
        return this.stdErrConsumer.getMaxLines();
    }

    public int getReturnCode() {
        int rc = -1;
        if (!this.completed && !this.destroyed) {
            while (true) {
                try {
                    rc = this.process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            this.healthTimer.cancel();
            try {
                this.stdErrConsumerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.completed = true;
        }
        return rc;
    }

    public OutputStream getStdinStream() {
        return this.process.getOutputStream();
    }

    public void setTimeout(int timeout) {
        this.healthTimerTask.setTimeout(timeout);
    }

    public void consumeOutput(StringBuffer buf) throws IOException {
        String line;
        BufferedReader rdr = this.getOutputReader();
        while ((line = rdr.readLine()) != null) {
            buf.append(line);
            buf.append('\n');
        }
    }

    public void consumeOutput() throws IOException {
        BufferedReader rdr = this.getOutputReader();
        while (rdr.readLine() != null) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy() {
        Exec exec = this;
        synchronized (exec) {
            this.process.destroy();
            this.destroyed = true;
        }
        this.healthTimer.cancel();
        this.stdErrConsumer.setStopRequested(true);
        this.stdErrConsumerThread.interrupt();
        try {
            this.stdErrConsumerThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String readLine() throws IOException {
        String answer = this.getOutputReader().readLine();
        this.healthTimerTask.update();
        return answer;
    }

    public BufferedReader getOutputReader() {
        if (this.outputReader == null) {
            this.outputReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        }
        return this.outputReader;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void run() throws IOException {
        this.process = this.command != null ? Runtime.getRuntime().exec(this.command, this.envp, this.dir) : Runtime.getRuntime().exec(this.cmdargs, this.envp, this.dir);
        this.healthTimer.schedule((TimerTask)this.healthTimerTask, 1000L, 1000L);
        this.stdErrConsumerThread = new Thread(this.stdErrConsumer);
        this.stdErrConsumerThread.start();
    }

    private class StdErrConsumer
    implements Runnable {
        private volatile boolean stopRequested = false;
        private int maxLines = 50;
        private List errorLines = new ArrayList();

        StdErrConsumer() {
        }

        public void run() {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(Exec.this.process.getErrorStream()));
                int lineCount = 0;
                while (!this.stopRequested && (line = reader.readLine()) != null) {
                    if (lineCount < this.maxLines) {
                        this.errorLines.add(line);
                        ++lineCount;
                    }
                    Exec.this.healthTimerTask.update();
                }
            }
            catch (InterruptedIOException interIO) {
                System.out.println("StdErrorThread interrupted.");
            }
            catch (IOException ioe) {
                System.out.println("Unexpected exception reading ExternalProcess stderr output; remainder ignored: " + ioe.toString());
            }
        }

        public int getMaxLines() {
            return this.maxLines;
        }

        public void setMaxLines(int maxLines) {
            this.maxLines = maxLines;
        }

        public boolean isStopRequested() {
            return this.stopRequested;
        }

        public void setStopRequested(boolean stopRequested) {
            this.stopRequested = stopRequested;
        }

        public List getErrorLines() {
            return this.errorLines;
        }
    }

    private class ProcessHealthTimerTask
    extends TimerTask {
        private volatile long lastResponseTime = 0L;
        private int timeout = 10000;

        ProcessHealthTimerTask() {
        }

        void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        synchronized void update() {
            this.lastResponseTime = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            System.out.println("TimerTask: running.");
            ProcessHealthTimerTask processHealthTimerTask = this;
            synchronized (processHealthTimerTask) {
                if (this.timeout > 0 && this.lastResponseTime + (long)this.timeout < System.currentTimeMillis()) {
                    System.out.println("TimeoutTask: Time out detected!");
                    Exec.this.destroy();
                }
            }
        }
    }
}

