/*
 * Decompiled with CFR 0.152.
 */
package com.dovetail.jzos;

public class ByteUtil {
    public static byte[] intAsBytes(int i) {
        byte[] bytes = new byte[]{(byte)(i >>> 24 & 0xFF), (byte)(i >>> 16 & 0xFF), (byte)(i >>> 8 & 0xFF), (byte)(i & 0xFF)};
        return bytes;
    }

    public static int bytesAsInt(byte[] bytes) {
        return ByteUtil.bytesAsInt(bytes, 0, bytes.length);
    }

    public static int bytesAsInt(byte[] bytes, int offset, int length) {
        if (length > 4) {
            throw new RuntimeException("Only 4 or fewer bytes can fit into an int");
        }
        int val = 0;
        int i = 0;
        while (i < length) {
            val |= (bytes[offset + length - 1 - i] & 0xFF) << i * 8;
            ++i;
        }
        return val;
    }

    public static long unpackLong(byte[] bytes, int offset, int length, boolean isSigned) {
        long val = 0L;
        int i = 0;
        while (i < length) {
            int high_digit = bytes[offset + i] >>> 4 & 0xF;
            int low_digit = bytes[offset + i] & 0xF;
            if (i == length - 1 && isSigned) {
                val = val * 10L + (long)high_digit;
                if (low_digit == 13 || low_digit == 11) {
                    val = -val;
                }
            } else {
                val = val * 100L + (long)(high_digit * 10) + (long)low_digit;
            }
            ++i;
        }
        return val;
    }
}

