package com.jsrsys.web;

/** JsrUser.java:    A simple container for session persistent values.
<BR> Sample Use:
<BR>JsrUser user = new JsrUser();
<BR>user.setValue(ValueName,Value);
<BR>user.getValue(ValueName,Value);
<BR>file1.Write(strfile1[]))
<BR>created 2005-02-05
*/

public class JsrUser
{ 
  static final String COPYRIGHT = 
  "Copyright 1998-2000, JSR Systems.  See: www.Jsrsys.com/copyright.";
  static final int MAXV = 100;
  JsrSysout sysout = new JsrSysout();
  String[]   valueName;
  String[]   value;
  int        vLen = 0;
  int        i    = 0;
  
  
  public JsrUser()  // null constructor
  {
     valueName = new String[MAXV];
     value     = new String[MAXV];
     
  }

  public void setValue(String vName, String v)
  {
      for (i =0; i < vLen; i++)
      {
        if (vName.equals(valueName[i]))
        {
            value[i] = v;
            break;
        }
      }
      sysout.display ("JsrUser--add:i ="+i+" vLen="+vLen+"/"+vName+"="+v);
      if (i == vLen)
      {
         valueName[i] = vName;
         value    [i] = v;
         vLen++;
      }
  } // end setValue method

  public String getValue(String vName)
  {
      for (i =0; i < vLen; i++)
      {
        if (vName.equals(valueName[i]))
        {
            return value[i];
        }
      }
      return "";
  }
  

} // end ReqsWho class 
