package com.jsrsys.web;

import java.sql.*;
import javax.naming.Context;
import javax.naming.InitialContext;
//import javax.sql.DataSource;
/**
  * SQL database access .
  */
public class JsrSQL
{
  static final String COPYRIGHT = 
  "Copyright 1998-2003, JSR Systems.  See: www.Jsrsys.com/copyright.";

/**
  *
  */

/**
  * null constructor: requires user to do setDataBaseName
  */
  public JsrSQL() {}  // null constructor: requires user to do setDataBaseName

/**
  <BR>  constructor w/ dataBaseName 
  <BR> each instance has own connection and dataBaseName
  <BR> Normal Use:
  <BR> * One (1) instance per open table
  <BR> * Works with an array of rowValues, one per Column/Field
  <BR> * setSelect(...everything after SELECT *)
  <BR> * getColNames()   // once after the SELECT (can be from multiple tables)...
  <BR> * getColDisplaySize() // same  THEN: for each row in resultSet
  <BR> * * setNextRow()
  <BR> * * getRowValue() // returns array of all Column/Field values for that row...
  <BR> * * update(rowValueArray)  // if [1] = "*new*" do insert.
  <BR> * * delete() // to delete current row.
  <BR> * Assumptions:
  <BR> * * [0] is WhoID, [1] is LastUpdate
  <BR> * setSQL and setIUD are alternate forms...
  */
  public JsrSQL(String dbName)
  {
    setDataBaseName(dbName);
  }

  static final String DBHOST = "localhost";
         Connection   conn; // one Connection per Class
         String dataBaseName = "";
         Statement    stmt; 
         ResultSet results;
         ResultSetMetaData rsmd;
  
  static JsrUtil u = new JsrUtil();
  JsrSysout sysout = new JsrSysout();
  JsrLineIn     in = new JsrLineIn();
  JsrLineOut   out = new JsrLineOut();

  
  String           sql = "";

  static int       tableNum = 0;
  static String[]  tableName;
  
  int       tableRow  = 0;  // # of fields in a table
  int       rowCount  = 0;  // # of rows with values in a table.
  int numberOfColumns = 0;  // # number Of Colums from last SELECT.
  String    type;
  int                i = 0;
  int       firstParen = 0;
  int        lastParen = 0;
  String[]   fieldName;
  String[]   fieldType;
  String[]   fieldLen;
  String[]   rowValue;
  boolean    newRow = false;
  String[]   colNames;
  int[]      displaySizes;
  boolean    forUpdate = false;
  
/**
  *  supply dataBaseName via call here, or constructor
  */
  public void setDataBaseName(String dbName)
  {
    dataBaseName = dbName;
    connect(dataBaseName);
    return;
  }

/**
  *  executes Query (fromName), return COUNT(*).
  */
  public int setSelectForUpdate(String fromName)
  {
      forUpdate = true;
      return setSelect(fromName);
  }


/**
  *  executes Query (fromName), return COUNT(*).
  */
  public int setSelect(String fromName)
  {
       int rowCount = 0;
       try
       {
         if (forUpdate)
         {
             stmt = conn.createStatement(ResultSet.TYPE_FORWARD_ONLY,
                                         ResultSet.CONCUR_UPDATABLE);
             forUpdate = false;
         }
         else
             stmt = conn.createStatement();
             
         sql = "SELECT COUNT(*) FROM " + fromName;
         results = stmt.executeQuery(sql);
         if (results == null)
         {
            sysout.display( " setSelect: result set is NULL");
            //System.exit(4);
            rowCount = 0;
            numberOfColumns = 0;
            rowValue = new String [1];
            rowValue [0] = "";
         }
         else
         {
           results.next();  // get count results;
           rowCount = results.getInt(1);
           sql = "SELECT * FROM " + fromName;
           results = stmt.executeQuery(sql);
           rsmd = results.getMetaData();
           numberOfColumns = rsmd.getColumnCount();
           rowValue = new String[numberOfColumns];
         }
         sysout.display( " setSelect: " + sql); 
         sysout.display( " " + rowCount + " rows "
                                        + numberOfColumns
                                        + " cols found in result set");
       }
       catch (SQLException E)
       {
            sysout.display( " setSelect: " + sql); 
            sysout.display( " exception: " + E.getMessage());
            rowCount = 0;
            numberOfColumns = 0;
            rowValue = new String [1];
            rowValue [0] = "";
       }
       return rowCount;

  }

/**
  *  executes Query (fromSQL), return column Count.
  */
  public int setSQL(String fromSQL)
  {
       int colCount = 0;
       boolean areResults = false;
       try
       {
         if (conn == null) areResults = false;
         else
         {
             stmt = conn.createStatement();
             areResults = stmt.execute(fromSQL);
         }
         if (!areResults)
         {
            sysout.display( " setSQL: colCount==0 for "+fromSQL);
            //System.exit(4);
            colCount = 0;
            numberOfColumns = 0;
            rowValue = new String [1];
            rowValue [0] = "";
         }
         else
         {
           
           results  = stmt.getResultSet();
           rsmd = results.getMetaData();
           colCount = numberOfColumns = rsmd.getColumnCount();
           rowValue = new String[numberOfColumns];
         }
         sysout.display( " setSQL: " + fromSQL); 
         sysout.display( " " + numberOfColumns + " cols found in result set");
       }
       catch (SQLException E)
       {
            sysout.display( " setSql: " + fromSQL); 
            sysout.display( " exception: " + E.getMessage());
            colCount = 0;
            numberOfColumns = 0;
            rowValue = new String [1];
            rowValue [0] = "";
       }
       return colCount;

  }

/**
  *  executes INSERT/UPDATE/DELETE (fromSQL), return rows updated.
  */
  public int setIUD(String fromSQL)
  {
       int rowCount = 0;
       try
       {
         stmt = conn.createStatement();
         sql = fromSQL;
         rowCount = stmt.executeUpdate(sql);
         sysout.display( " setIUD: " + sql + " " + rowCount + " rows updated");
       }
       catch (SQLException E)
       {
            sysout.display( " setIUD: " + sql); 
            sysout.display( " exception: " + E.getMessage());
            rowCount = 0;
       }
       return rowCount;
  }

/**
  *  return all Column Names for most recent setSelect
  */
  public String[] getColNames()
  {
    colNames = new String[numberOfColumns];
    for (int i = 0; i < numberOfColumns; i++)
         try
         {
           colNames[i] = rsmd.getColumnName(i+1);
         }
         catch (SQLException E)
         {  sysout.display( " getColumnName exception: "
                                           + E.getMessage());
         }
    return colNames;
  }

/**
  *  return all Display Sizes for most recent setSelect
  */
  public int[] getColDisplaySize()
  {
    displaySizes =  new int[numberOfColumns];
    for (int i = 0; i < numberOfColumns; i++)
         try
         {
           displaySizes[i] = rsmd.getColumnDisplaySize(i+1);
         }
         catch (SQLException E)
         {  sysout.display( " getColumnDisplaySize exception: "
                                           + E.getMessage());
         }
    return displaySizes;
  }

/**
  *  moves cursor to next row, return false if no more rows. 
  */
  public boolean setNextRow()
  {
       boolean isNext = false;
       try
       {
          isNext = results.next();
       }
       catch (SQLException E)
       {  sysout.display( " setNextRow SQL exception: "
                                         + E.getMessage());
       }
       catch (NullPointerException E)
       {  sysout.display( " setNextRow SQL result set is NULL: "
                                         + E.getMessage());
       }
       return isNext;

  }
  
/**
  *  returns String[] of all field (column) values for current row. 
  */
  public String[] getRowValues()
  {
    for (int k=0; k < rowValue.length; k++) rowValue[k] = getString(k+1);
    return rowValue;

  }

/**
  *  delete current Row
  */
  public String delete(String[] newRowValue)
  {
    String status = "****";  // means all OK.  Otherwise, and error code.
    sysout.display("Deleting Row *ID=" + newRowValue[0]);
    try
            {
                 results.deleteRow();
            }
            catch (SQLException E)
            {  sysout.display( " deleteRow() SQL exception: "
                                              + E.getMessage());
               status = "SQL: "+ E.getMessage();
            }
    if (status.equals("****")) status += " row deleted!!!";
    return status;

  }

  
/**
  *  reverse of getRowValues(): assumes that newRowValue "matches" rowValue[]
  <BR> *  assumes: [0] == WhoID, [1] == LastUpdate.
  <BR> *  if [1] == "*new*", then do insert, else do update. 
  */
  public String update(String[] newRowValue)
  {
    String status = "****";  // means all OK.  Otherwise, and error code.
    newRow = false;  
    int fieldsChanged = 0;   // if zero means no fields changed so no update.
    if (newRowValue[1] != null && newRowValue[1].equals("*new*"))
    {
        try {results.moveToInsertRow();}
            catch (SQLException E)
            {  sysout.display( " moveToInsertRow "
                                              + E.getMessage());
            }
        sysout.display("JsrSQL: Assume addition");
        newRow = true;
    }
    for (int k=0; k < rowValue.length; k++)
    {
        //sysout.display("Comparing Field: "+ colNames[k]+"="
        //              + newRowValue[k] + ":"+rowValue[k]);
        if (newRow     || !rowValue[k].equals(newRowValue[k])   )
         // new record OR   value has changed  THEN update...
        {
            fieldsChanged++;
            try
            {
               sysout.display("Updating "+ colNames[k]+" to: "+ newRowValue[k]
                                                    +" from: "+    rowValue[k]);
               results.updateString(k+1, newRowValue[k]);
               rowValue[k] = newRowValue[k]; // so won't update again on second pass. 
            }
            catch (Exception E)
            {  sysout.display( " update("+(k+1)+") SQL exception: "
                                              + E.getMessage());
               status = "SQL: "+ E.getMessage();
            }
        }
    }
    if (status.equals("****") && fieldsChanged > 0)
    {
            sysout.display("Updating Row *ID=" + newRowValue[0]);
            try
            {
               rowValue[1] = u.getDateTime().substring(0,16);
               results.updateString(2, rowValue[1] );
               if (newRow)
               {
                  results.insertRow();
                  //results.moveToCurrentRow();
                  results.last(); // see if new row is last row.  
               }
               else
                  results.updateRow();
            }
            catch (SQLException E)
            {  sysout.display( " updateRow() SQL exception: "
                                              + E.getMessage());
               status = "SQL: "+ E.getMessage();
            }
            catch (Exception E)
                        {  sysout.display( " updateRow() Exception: "
                                              + E.getMessage());
               status = "***: "+ E.getMessage();
            }

    }

    if (status.equals("****")) status += " "+fieldsChanged
                                       + " fields were changed.";
    return status;

  }

/**
  *  returns String value for colNum
  */
  public String getString(int colNum)
  {
    String fixResult;
     try
     {
        fixResult = results.getString(colNum);
     }
     catch (SQLException E)
     {  //sysout.display( " getString("+colNum+") SQL exception: "
          //                             + E.getMessage()
            //                           + " newRow="+newRow
              //                         + " rowValue="+rowValue[colNum-1]+"!"
                //                       );
        if (newRow)
           fixResult = rowValue[colNum-1];
        else
        {
            fixResult = "";
            if (colNum == 2) fixResult = "*new*";
        }
     }
     
     if (fixResult == null)
     {
         fixResult = "";
         if (colNum == 2) fixResult = "*new*";
     }
     return fixResult;
  }

/**
  * return String value for colName
  */
  public String getString(String colName)
  {
    String fixResult;
     try
     {
        fixResult = results.getString(colName);
     }
     catch (SQLException E)
     {  //sysout.display( " getString("+colName+ ") SQL exception: "
        //                               + E.getMessage());
        fixResult = "";
        if (colName.equals("LastUpdate")) fixResult = "*new*";
     }
     
     if (fixResult == null)
         fixResult = "";
         if (colName.equals("LastUpdate")) fixResult = "*new*";
     return fixResult;
  }

/**
  *  called by setDataBaseName
  */
  private void connect(String dbName)
  {
    try
    {
      Class.forName("org.gjt.mm.mysql.Driver");
    }

    catch (Exception E) {sysout.display(" Unable to load driver"); E.printStackTrace();}
    
    try
    {
      sql = "Connection to jdbc/MySql:"; 
      //String jdbcConnect = "jdbc:mysql://" + DBHOST + "/" + dbName;
      //sysout.display( " Getting Connection: "+jdbcConnect);
      //conn = DriverManager.getConnection (jdbcConnect);
        	Context myContext = new InitialContext();
        	Context envContext = (Context)myContext.lookup("java:comp/env");
        	javax.sql.DataSource ds = (javax.sql.DataSource)envContext.lookup("jdbc/MySql");
        	conn = ds.getConnection();
      stmt = conn.createStatement();
      sql = "USE "+ dbName; // attempt to mymic jdbcConnect set for dbName! 
      stmt.execute(sql); 
      sysout.display(sql + ": connection to jdbc/MySql established.");
    }
    catch (SQLException E)
    {  sysout.display(sql+ ": connect SQL exception: "
                                      + E.getMessage());
       //System.exit(4);
    }
    catch(Exception eOther)
    {  sysout.display(sql+ ": connect Other exception: "
                                      + eOther.getMessage());
       //System.exit(4);
    }
  }

/**
  *  closes results, stmt, conn. 
  */
  public void close()
  {
    try
    {
      if (results != null) results.close();
      if (stmt    != null) stmt.close();
      if (conn    != null) conn.close();
    }
    catch (SQLException E)
    {sysout.display( " close SQL exception: "
                                    + E.getMessage());
    }
    catch (NullPointerException E)
    {sysout.display( " close SQL result set is NULL: "
                                    + E.getMessage());
    }
  }

/**
  *  returns int # of fields (columns) for current table
  */
  public int getFields(String tableName)
  {
    try
    {
      sql = "DESCRIBE " + tableName;
      // 1=Field, 2=Type, 3=Null, 4=Key, 5=Default, 6= Extra

      sysout.display( " getFields executeQuery: " + sql);
      results = stmt.executeQuery(sql);
      tableRow = 0;
      while ( results.next() )
      {
        tableRow++;
      }
      //sysout.display( "# Fields in "+ tableName+": "+tableRow );
      fieldName = new String[tableRow];
      fieldType = new String[tableRow];
      fieldLen  = new String[tableRow];
      rowValue  = new String[tableRow];
      results = stmt.executeQuery(sql);
      int i = 0;
      while ( results.next() )
      {
         fieldName[i] = getString(1);
                 type = getString(2);
           firstParen = type.indexOf ("(");
            lastParen = type.indexOf (")");
         if (firstParen > 0 && lastParen > firstParen)
         {
            fieldLen  [i] = type.substring(firstParen+1,lastParen);
            fieldType [i] = type.substring(0,firstParen);
         }
         else
         {
            fieldLen  [i] = "";
            fieldType [i] = type;
         }
        
        i++;
      }
    }
    catch (SQLException E)
    {  sysout.display( " getFields SQL exception: "
                                      + E.getMessage());
    }
    return tableRow;
  }
/**
  *  returns String[] of all field (column) names for current table (set by getFields).
  <BR>  only valid if getFields(tableName) done first. 
  */
  public String[] getNames()
  {
    return fieldName;
  }


/**
  *  return String[] of all tables in this database
  <BR>  Windows MySQL returns all lower-case, change to Xxxxx (toUpperCase on 1st digit). 
  */
  public String[] getTables(String dbName)
  {
    if (tableNum == 0) connect(dbName);
    try
    {
     
      sql = "SHOW TABLES";
      // 1=Field, 2=Type, 3=Null, 4=Key, 5=Default, 6= Extra

      sysout.display( " get Tables executeQuery: " + sql);
      results = stmt.executeQuery(sql);
      tableNum = 0;
      while ( results.next() )
      {
        tableNum++;
      }
      sysout.display( "# Tables in "+ dbName+": "+tableNum );
      tableName = new String[tableNum];
      results = stmt.executeQuery(sql);
      i = 0;
      while ( results.next() )
      {
        tableName[i] = getString(1);
        tableName[i] = tableName[i].substring(0,1).toUpperCase()+tableName[i].substring(1);
        sysout.display((i+1)+" "+tableName[i]);
        i++;
      }
    }
    catch (SQLException E)
    {  sysout.display( " getTables SQL exception: "
                                      + E.getMessage());
        
    }
    return tableName;
  }

} // end class JsrSQL
