class IbfReport
{
    // 2002-06-28 -- put null Char in col 1 of output of first and last lines.
    //               make RECORD TOTAL be # print lines, not # detail records, and fill last line w/ null char.

  static final String COPYRIGHT = 
  "Copyright 2000, Imperial Business Forms & JSR Systems.  See: www.Jsrsys.com/copyright.";
  static final int    MAXREC = 50000;

  JsrSysout sysout    = new JsrSysout();
  JsrUtil   u         = new JsrUtil();
  String[]    inputLine = new String[MAXREC];
  JsrLineIn   input   = new JsrLineIn();
  JsrSortByKey sort   = new JsrSortByKey();
  
  JsrLineOut output   = new JsrLineOut();

  int        line100  = 0;
  int     recNum      = 0;
  int     i           = 0;  
  int     iMax        = 0;
  int[]   keys;
  int testMax      = 0;  //setting to non-zero will process only first n records. 
  int pageNum      = 0;
  int lineCount    = 99;
  int linesPerPage = 84;
  
  String  tl1   = u.padRight("1",133);
  String  tl2   = u.padRight("0",133);
  String  tl2b  = " ";
  
  String hdr1   = u.padRight(" ",133);
  
  String today = u.getDateTime();
  String year4 = today.substring(0,4);
  String mm2   = today.substring(5,7);
  String[] mmName = {"  JANUARY",
                     " FEBRUARY",
                     "    MARCH",
                     "    APRIL",
                     "      MAY",
                     "     JUNE",
                     "     JULY",
                     "   AUGUST",
                     "SEPTEMBER",
                     "  OCTOBER",
                     " NOVEMBER",
                     " DECEMBER"};
  
  int    intYear;
  int    intMonth;
  String ccAll;
  String ccBrch;
  String ccMonth;
  String division  = "    ";
  String costLabel = "    ";
  String reportName = "IbfReport";
  String nullChar   ="\000";
  String recordTotal = "\000RECORD TOTAL = ";
  int    recordCount = 0;

    public static void main(String argv[])
    {
        IbfReport IbfReport = new IbfReport();
        IbfReport.run(argv);
    }
    
    public void run(String parm[])
    {
      lineCount = 99;   // repeat of same report starts on new page.
      pageNum   =  0;   // start each report with new page numbers 2000-12-17
      setReportName();  // sets reportName for following displays, etc.
      setSortKeys();    // set sort keys array values...
      sort.setEbcdic(true);  // sort numbers after all else.  if false, then sort ASCII (default)
      sysout.display(reportName+"--"+COPYRIGHT);
      sysout.display(reportName+"--usage: "+reportName+" <Control Card> <input> <output> ");
      if (parm.length < 3)
      {
        sysout.display(reportName+"--requires three parameters");
        return;
      }

        input.setName(parm[0]); // set for control card input
        output.setName(parm[2]);
        input.getNext(); // read control card.
        ccAll = u.padRight(input.getLine(),40);  // this eliminates IndexOutOfRange errors in setCC!
        input.setName(parm[1]);  // reset for datafile input
        
        setCC();  // sets Control Card (CC) fields
        
        if (ccBrch.equals("30")) division = "DALLAS DIVISION";
        if (ccBrch.equals("37")) division = "HOUSTON DIVISION";
        if (ccBrch.equals("72")) division = "MONTGOMERY DIVISION";
        if (ccBrch.equals("73")) division = "MOBILE DIVISION";
        if (ccBrch.equals("74")) division = "MERIDIAN DIVISION";
        if (ccBrch.equals("75")) division = "LAKELAND DIVISION";
        intYear    = u.getInt(year4);
        intMonth   = u.getInt(ccMonth);

        if (intMonth < 1 || intMonth > 12)
        {
            sysout.display(reportName+"--Invalid month, terminating execution");
            sysout.display(reportName+"--MM="+intMonth+" cc="+ccAll);
            System.exit(4);
        }
        if (mm2.equals("12") && ccMonth.equals("01")) intYear++;
        sysout.display("Year="+intYear+" MM="+intMonth);

        setTl2();   // sets tl2 title line
                           
        setHdr1();  // sets hdr2 header

        
      i = 0;
      while (0 <= (recNum=input.getNext())) 
      {
         inputLine[i] = input.getLine();
         //sysout.display(inputLine[i]);
         iMax=i;
         i++;
         line100++;
         if (line100 == 100)
         {
            line100 = 0;
            sysout.speedometer("Loading record: "+recNum);
         }//sysout.display("Loading record: "+recNum+" iMax="+iMax);
         
         if (recNum == testMax) break; // set test EOF
      }
      if (i == 0)
      {
        sysout.display("Empty Input file, terminating run.");
        System.exit(4);
      }
      iMax++;
      keys[0] = iMax;  // set actual table length.
      sysout.display(u.getDateTime()+"--"+parm[1]+" Begin sort");
      sort.sort(inputLine, keys);
      sysout.display(u.getDateTime()+"--"+parm[1]+" End-- sort");


      for (i = 0; i < iMax; i++)
      {
         //sysout.display(inputLine[i]);

         if (lineCount > linesPerPage) newPage();
         lineCount++;
         setDetail();  // method overridden 
      }
      // out133("0"+"Record Total = " + u.padLeft(iMax,10) );
      recordTotal += u.padZero(recordCount,16);
      while (recordTotal.length() < 133)
          recordTotal += nullChar;
      out133(recordTotal);
      
      output.close();
      
          
 
    }
    String picNum(String num)
    {
        int wholeInt;
        wholeInt = u.getInt(num);
        if (wholeInt == Integer.MIN_VALUE)
           return "     "+num.substring(0,5);
        else
           return u.padLeft(wholeInt,10,2);
    }
    void out133(String shortLine)
    {
        recordCount++;
        output.setLine(u.padRight(shortLine,133));
    }
        
    void newPage()
    {
        pageNum++;
        out133(tl1);
        out133(tl2+u.padLeft(pageNum,5)+tl2b);
        out133(hdr1);
        out133("                                               "); 
        lineCount = 4;
    }

    // it is expected the all the following methods will be overridden
    
    void setReportName()
    {
    }

    void setSortKeys()
    {
         keys = new int[] {0,1,1,0,};  // set default keys...
        //keys [0] = sort table length (actual), rest column,length,A/D  triplets
 
    }

    void setCC()
    {
    }

    void setTl2()
    {
    }

    void setHdr1()
    {
    }

    void setDetail()
    {
        out133("     ");
    }
}