class IbfExtract
{

  static final String COPYRIGHT = 
  "Copyright 2000, JSR Systems.  See: www.Jsrsys.com/copyright.";
  static final int    MAXOUT = 40;
  static final int    RECLEN = 128;

  JsrSysout sysout    = new JsrSysout();
  JsrUtil   u         = new JsrUtil();
  String    inputLine = " ";
  String     nextLine = "";
  JsrLineIn   input   = new JsrLineIn();
  
  JsrLineOut[] output   = new JsrLineOut[MAXOUT];
  String[]     outName  = new String[MAXOUT];
  int        line100  = 0;
  int     recNum      = 0;
  int     i           = 0;  // output index
  int     iMax        = 0;
  int     blankError  = 0; 

  String    fileName    = "";

    public static void main(String argv[])
    {
        IbfExtract IbfExtract = new IbfExtract();
        IbfExtract.run(argv);
    }
    
    public void run(String parm[])
    {
      sysout.syslog("logIbfExtract.txt");
      sysout.display("IbfExtract--"+COPYRIGHT);
      sysout.display("IbfExtract--usage: IbfExtract <catalog file>");
      if (parm.length < 1)
      {
        sysout.display("IbfExtract--requires one parameters");
        return;
      }
       for (i = 0; i < MAXOUT; i++) {outName[i] = "";}
       sysout.display("IbfExtract--Begin Extract: "+u.getDateTime() );

       input.setName(parm[0]);

      recNum=input.getNext();
      nextLine = input.getLine(); 
      while (0 <= recNum) 
      {
         //sysout.display(recNum+"/"+nextLine.length()+"/"+nextLine.substring(0,20));
         if (nextLine.length() == RECLEN)
         {
            inputLine = nextLine;
            recNum    = input.getNext();
            nextLine  = input.getLine();
         }
         else
         if (nextLine.length() > RECLEN)
         {
            inputLine = nextLine.substring(0,RECLEN);
            nextLine  = nextLine.substring(RECLEN);
         }
         else
         if (nextLine.length() < RECLEN)
         {
            inputLine = u.padRight(nextLine,RECLEN);
            recNum    = input.getNext();
            nextLine  = input.getLine();
         }

         fileName  = inputLine.substring(0,10).trim();
         if (fileName.equals("RP5226")) fileName += "."+inputLine.substring(17,21);
         if (fileName.length() == 0)
         {
            blankError++;
            if (blankError <=5)
                sysout.display("IbfExtract--record # "
                                +recNum+" has blank col 1-10 (record code), lrecl="
                                +inputLine.length() );
            continue;
         }
         for (i = 0; i < iMax && !fileName.equals(outName[i]); i++) {}
         //sysout.display("*"+fileName+i+"*");
         if (i == iMax)
         {
            iMax++;
            output[i]  = new JsrLineOut();
            outName[i] = fileName;
            output[i].setName(fileName);
            sysout.display("*"+fileName+"["+i+"]");
         }
         line100++;
         if (line100 == 100)
         {
            line100 = 0;
            sysout.speedometer("Copying record: "+recNum);
         }

         output[i].setLine(inputLine);
      }
      for (i = 0; i < iMax; i++)
      {
        output[i].close();
      }
      
      if (blankError > 0)
          sysout.display("IbfExtract--"+blankError+" record code errors found!");

      sysout.display("IbfExtract--End Extract: "+u.getDateTime() );
     
 
    }
}