/*
 * JsrSortByKey: sort array with multiple keys (start,len,A/D).
 *   int[] keys;   // [0] = table length, [1],[2],[3],... column,length,A/D key triplets...
 *   // [1] is left column (1 is first column)
 *   // [2] is length of key segment
 *   // [3] 0 = sort ascending, else sort descending (usually -1).  
 */
public class JsrSortByKey 
{
  static final String COPYRIGHT = 
  "Copyright 2004, JSR Systems.  See: www.Jsrsys.com/copyright.";
   /* This is a generic version of C.A.R Hoare's Quick Sort 
    * algorithm.  This will handle arrays that are already
    * sorted, and arrays with duplicate keys.
    *
    * @param a       a String array
    * @param lo0     left boundary of array partition
    * @param hi0     right boundary of array partition
    */
    
   JsrSysout sysout = new JsrSysout();
   int[] keys;   // [0] = table length, [1],[2],[3],... column,length,A/D key triplets...
   // [1] is left column (1 is first column)
   // [2] is length of key segment
   // [3] 0 = sort ascending, else sort descending (usually -1).  
   int i;
   String loKey;
   String hiKey;
   int iCompare;
   boolean ebcdic = false;
   
   public void setEbcdic(boolean onOff)
   {
      ebcdic = onOff;
   }
/*
 *   sort (String[] to be sorted, int[] specifies multiple keys (start,len,A/D)).<BR>
 *   // [0] = table length, [1],[2],[3],... column,length,A/D key triplets...<BR>
 *   // [1] is left column (1 is first column)<BR>
 *   // [2] is length of key segment<BR>
 *   // [3] 0 = sort ascending, else sort descending (usually -1).<BR>
 *   if whole table is to be sorted, then keys[0] = table.length();<BR>
 */
    
   public void sort(String a[], int lkey[])
   {
      String dispText = "JsrSortByKey: Table len="+lkey[0]+" Start/lenth/A-D): ";
      keys = lkey;
      // sysout.display("Sorting table of length: "+lkey[0]);
                        
      for (i = 1; i < lkey.length; i+=3)
      {
         dispText += +lkey[i]+"/"+lkey[i+1]+"/";
         if (lkey[i+2] == 0) dispText += "A"+":";
         else                dispText += "D"+":";
          
         //sysout.display("Column/length/A-D): "+lkey[i]+"/"+lkey[i+1]+"/"+lkey[i+2]);
         keys[i]--;
         keys[i+1] = keys[i] + keys[i+1];
         //sysout.display("*substring.../A-D): "+lkey[i]+"/"+lkey[i+1]+"/"+lkey[i+2]);

      }
      sysout.display(dispText);
      JsrQuickSort(a, 0, lkey[0] - 1);
   }

   private int compareKeys(String aLo, String aMid)
   {
      iCompare = 0;
      for (i = 1; (i < keys.length && iCompare == 0); i+=3)
      {
        //sysout.display("compareKeys Index[i]="+i+" keys.length="+keys.length);
        loKey =  aLo.substring(keys[i],keys[i+1]).toLowerCase();
        hiKey = aMid.substring(keys[i],keys[i+1]).toLowerCase();
        if (ebcdic)
        {
           iCompare = 0;
           int c    = 0;
           for (c = 0; c < loKey.length(); c++)
           {
               if (loKey.charAt(c) < hiKey.charAt(c))
               {
                   //sysout.display("@="+c+"<");
                   iCompare = -1;
                   break;
               }
               if (loKey.charAt(c) > hiKey.charAt(c))
               {
                   //sysout.display("@="+c+">");
                   iCompare = +1;
                   break;
               }
               //sysout.display("@="+c+"==");
            
           }
           if (iCompare != 0)
           {
               if ((Character.isDigit(loKey.charAt(c))  &&
                   !Character.isDigit(hiKey.charAt(c)))
               ||  (Character.isDigit(hiKey.charAt(c)) &&
                   !Character.isDigit(loKey.charAt(c)))   )
               {
                  iCompare = - iCompare;
                  //sysout.display("Reversing sign/EBCDIC");
               }
           }
           //sysout.display(loKey+"/"+hiKey+"="+iCompare+"charAt("+c+")");
        }
        else
           iCompare = loKey.compareToIgnoreCase(hiKey);  // normal ascii compare
        
        if (iCompare != 0 && keys[i+2] != 0) iCompare = - iCompare;
           // if descending, modify result of compare.
        //sysout.display("Comparing: "+loKey+"/"+hiKey+"*="+iCompare);

      }
      return iCompare; 
   }
   
   void JsrQuickSort(String a[], int lo0, int hi0) 
   {
      int lo = lo0;
      int hi = hi0;
      String mid;

      if ( hi0 > lo0)
      {

         // Arbitrarily establishing partition element at the midpoint.
         mid = a[ ( lo0 + hi0 ) / 2 ];

         // loop through the array until indices cross
         while( lo <= hi )
         {
            // find the first element that is greater than or equal to 
            // the partition element starting from the left Index.
	     while( ( lo < hi0 ) && ( compareKeys(a[lo], mid) < 0 ))
		 ++lo;

            // find an element that is smaller than or equal to 
            // the partition element starting from the right Index.
	     while( ( hi > lo0 ) && ( compareKeys(a[hi], mid) > 0 ))
		 --hi;

            // if the indexes have not crossed, swap
            if( lo <= hi ) 
            {
               swap(a, lo, hi);
               ++lo;
               --hi;
            }
         }

         // If the right index has not reached the left side of array
         // must now sort the left partition.
         if( lo0 < hi )
            JsrQuickSort( a, lo0, hi );

         /* If the left index has not reached the right side of array
          * must now sort the right partition.
          */
         if( lo < hi0 )
            JsrQuickSort( a, lo, hi0 );

      }
   }

   private void swap(String a[], int i, int j)
   {
      String T;
      T = a[i]; 
      a[i] = a[j];
      a[j] = T;

   }


}
