/**
 *Convert input to Rich Text Format
 */
public class JsrRTF
{
  // 2003-06-05 fix if input length = 1 and ccChar has value ("1"...).
  // 2002-03-25 add methods to make this callable with no input (main calls methods)
  //
  // 2002-01-03 add support for sl### parameter (line spacing) 240 = 6 LPI.  180 = 8 LPI.
  // 2002-01-01 add Webdings as \f3.
  // 2001-12-30 add Monotype Sorts as \f1.  To use input "\f1 ...\f0"
  //            where ... can be any string that converts to what you want.  'z' is black box.
  //            the \f1 is an RTF command that switches to font1, \f0 goes back to default font. 
  //            also add Wingdings as \f2.   To use input "\f2 ...\f0".
  //            Be sure to put space after \f1 or \f2, then data.
  //            Add NoEsc parameter to turn off edit of "\" to "\\", and { and }.
  // 2001-12-25 change margins to l 600 r 700 (hpdj min) t 450 b 700 (hpdj min).
  //            drop parm 2 as output file, output will always be input.rtf.
  //            add options 10cpi, 12cpi, and l= r= t= b= fs= face=.
  //            default l=600, r=700, t=450, b=700, fs=14, face=Lucida Console.
  //            if 10cpi, change fs=24 to generate 10 cpi.
  //            if 12cpi, change fs=20 to generate 12 cpi.
  //            ---------------------------------------------------------------------
  // 2001-08-08 change fs16 to fs14 and margr200 to margr400.
  //            fs14 to fit page, margr400 to eliminate "print outside margin" error.
  //            also change JsrLineIn/Out to OO methods (setName, getNext...).  
  static final String COPYRIGHT = 
  "Copyright 2000-2002, JSR Systems.  See: www.Jsrsys.com/copyright.";

     JsrSysout    sysout    = new JsrSysout();
     JsrUtil     u         = new JsrUtil();
     String      inputFile = " ";
     String      inputRec  = " "; 
     JsrLineIn   input     = new JsrLineIn();
     String     outputFile = " ";
     String     outputRec  = " ";
     JsrLineOut output     = new JsrLineOut();
     String     ccChar     = "*";
     String     startLine  = "";
     String     margl      = "600";
     String     margr      = "700";
     String     margt      = "450";
     String     margb      = "700";
     String     fs         = "14";
     String     sl         = "";
     String     face       = "Lucida Console";
     boolean    editEsc    = true;
/**
 *Set Right Margin value iii. (default 700).
 */
    public void setMargl(String newValue)
    {
        margl = newValue;
    }
/**
 *Set Left Margin value iii. (default 600).
 */
    public void setMargr(String newValue)
    {
        margr = newValue;
    }
/**
 *Set Top Margin value iii. (default 450).
 */
    public void setMargt(String newValue)
    {
        margt = newValue;
    }
/**
 *Set Bottom Margin value iii. (default 700).
 */
    public void setMargb(String newValue)
    {
        margb = newValue;
    }
/**
 *Set Font Size value ii.  (default 14).
 */
    public void setFs(String newValue)
    {
        fs = newValue;
    }
/**
 *Set Line Height value. iii (default null).<BR>
 *    Line Height varies depending on Font Size.<BR>
 *    For Font Size 12, sl=240.   
 */
    public void setSl(String newValue)
    {
        sl = "\\sl"+newValue;
    }
/**
 *Set Font Face (default "Lucida Console").
 */
    public void setFace(String newValue)
    {
        face = newValue;
    }
/**
 *Set Edit Escape characters. (default = true).<BR>
 *Set to False if you want RTF command embedded in text to be interpreted as commands.
 */
    public void setEditEsc(boolean newValue)
    {
        editEsc = newValue;
    }

/**
 *Opens output file fileName (do NOT include .rtf extension). <BR>
 *If another file is open, this will close it and open another.
 */
    public void setName(String fileName)
    {

      if (outputFile.length() != 1) close();
      //sysout.display("lastDot="+parm[0].lastIndexOf("."));
      outputFile = fileName + ".rtf";
      
      //sysout.display("Reading from: " + inputFile);
      //sysout.display("Writing   to: " + outputFile);
      outputRec = "{\\rtf1\\ansi\\ansicpg1252\\deff0\\deflang1033"+
                  "{\\fonttbl {\\f0\\fmodern\\fprq1\\fcharset0 "+face+";}"+
                  "{\\f1\\fnil\\fprq2\\fcharset2 Monotype Sorts;}"+
                  "{\\f2\\fnil\\fprq2\\fcharset2 Wingdings;}"+
                  "{\\f3\\froman\\fprq2\\fcharset2 Webdings;}}"+
                  "{\\colortbl ;\\red0\\green0\\blue0;}"+
                  "\\uc1\\pard\\cf1\\ulnone\r\n\\f0\\fs"+fs+
                  "\\margl"+margl+"\\margr"+margr+"\\margt"+margt+"\\margb"+margb+sl;
      output.setName(outputFile);
      output.setLine(outputRec);
    }

/**
 * Write a newPage command to RTF output file.
 */
    public void setPage()
    {
        startLine = "\\page ";
    }
    
/**
 * Write a line to RTF output file.
 */
    public void setLine(String newLine)
    {
        outputRec = newLine;
        if (editEsc)
        {
           if (outputRec.indexOf("\\") != -1)
               outputRec = u.replaceAll(outputRec,"\\","\\\\");
           if (outputRec.indexOf("{") != -1)
               outputRec = u.replaceAll(outputRec,"{","\\{");
           if (outputRec.indexOf("}") != -1)
               outputRec = u.replaceAll(outputRec,"}","\\}");
        }
        output.setLine(startLine + outputRec);
        startLine = "\\line ";
    }

/**
 * Close any open output file.
 */
    public void close()
    {
      outputRec = "}";
      output.setLine(outputRec);
      output.close();
    }


/** main is to run from command line.
  * run w/o parameters to see command line options. <BR>
  * 
  * usage: <BR>JsrRTF &lt;input file&gt; &lt;optional parms...&gt;"); <BR>
  * defaults:<BR> l=600 r=700 t=450 b=700     (margins)"); <BR>
  *           (margins in TWIPS, 2400 TWIPS=1 inch)"); <BR>
  *           sl=null    (sl=240=6LPI, sl=180=8LPI)"); <BR>
  *           fs=14           =Word Font Size  7"); <BR>
  *           10cpi sets fs=24=Word Font Size 12"); <BR>
  *           12cpi sets fs=20=Word Font Size 10"); <BR>
  *           face=Lucida Console (f0),"); <BR>
  *           \\f1=Monotype Sorts, \\f2=Wingdings, \\f3=Webdings"); <BR>
  *           NoEsc turns off edit of \\ { and } to \\ \\{ and \\},"); <BR>
  *           so can embed \\f# ... \\f0 commands.");  <BR>
  *
  */
    public static void main(String parm[])
    {
      JsrRTF jsr = new JsrRTF();
      jsr.run(parm);
      return;
    }
    private void run(String parm[])
    {
      sysout.display("JsrRTF--"+COPYRIGHT);
      sysout.display("JsrRTF-----usage: JsrRTF <input file> <optional parms...>");
      sysout.display("JsrRTF--defaults: l=600 r=700 t=450 b=700     (margins)");
      sysout.display("JsrRTF--          (margins in TWIPS, 2400 TWIPS=1 inch)");
      sysout.display("JsrRTF--          sl=null    (sl=240=6LPI, sl=180=8LPI)");
      sysout.display("JsrRTF--          fs=14           =Word Font Size  7");
      sysout.display("JsrRTF--          10cpi sets fs=24=Word Font Size 12");
      sysout.display("JsrRTF--          12cpi sets fs=20=Word Font Size 10");
      sysout.display("JsrRTF--          face=Lucida Console (f0),");
      sysout.display("JsrRTF--          \\f1=Monotype Sorts, \\f2=Wingdings, \\f3=Webdings");
      sysout.display("JsrRTF--          NoEsc turns off edit of \\ { and } to \\ \\{ and \\},");
      sysout.display("JsrRTF--          so can embed \\f# ... \\f0 commands.");
      sysout.display("JsrRTF--Warning: x=### commands must be enclosed in quotes.");
      sysout.display("JsrRTF--Example: JsrRTF fileName.txt \"l=400\" \"r=400\".");
      if (parm.length < 1)
      {
        sysout.display("JsrRTF--requires input file parameters");
        return;
      }
      inputFile = parm[0];

      
      for (int i=1; i < parm.length; i++)
      {
         sysout.display("JsrRTF--Override: "+parm[i]);
         if (parm[i].equalsIgnoreCase("10cpi"))               setFs("24");
         if (parm[i].equalsIgnoreCase("12cpi"))               setFs("20");
         if (parm[i].equalsIgnoreCase("noesc"))               setEditEsc(false);
         if (parm[i].length() > 2 &&
             parm[i].substring(0,2).equalsIgnoreCase("l="))   setMargl(parm[i].substring(2));
         if (parm[i].length() > 2 &&
             parm[i].substring(0,2).equalsIgnoreCase("r="))   setMargr(parm[i].substring(2));
         if (parm[i].length() > 2 &&
             parm[i].substring(0,2).equalsIgnoreCase("t="))   setMargt(parm[i].substring(2));
         if (parm[i].length() > 2 &&
             parm[i].substring(0,2).equalsIgnoreCase("b="))   setMargb(parm[i].substring(2));
         if (parm[i].length() > 3 &&
             parm[i].substring(0,3).equalsIgnoreCase("fs="))  setFs(parm[i].substring(3));
         if (parm[i].length() > 3 &&
             parm[i].substring(0,3).equalsIgnoreCase("sl="))  setSl(parm[i].substring(3));
         if (parm[i].length() > 5 &&
             parm[i].substring(0,5).equalsIgnoreCase("face=")) setFace(parm[i].substring(5));

      }

      setName(parm[0].substring(0,parm[0].lastIndexOf(".")));
      int          recNum = 0;
      input.setName(inputFile);
      while (0 <= (recNum=input.getNext())) 
      {
         inputRec = input.getLine();
         if (inputRec.length() < 2)
         {
            ccChar       = " ";
            if (inputRec.length() == 1) ccChar = inputRec.substring(0,1);
            inputRec = " ";
         }
         else
         {
            ccChar       = inputRec.substring(0,1);
            inputRec = inputRec.substring(1);
         }
         //sysout.display("len="+inputRec.length()+"="+ccChar+"/"+inputRec);
         startLine = "";
         if (ccChar.equals(" ")) startLine = "\\line ";
         else
         if (ccChar.equals("+")) startLine = "\\line "; // can't do overstrike lines!d
         else
         if (ccChar.equals("0")) startLine = "\\line\\line ";
         else
         if (ccChar.equals("-")) startLine = "\\line\\line\\line ";
         else
         {
                                 startLine = "\\line ";
           if (ccChar.equals("1"))
             if (recNum != 1)      setPage();
             else                  startLine = "";
         }

         setLine(inputRec);
      }

      close();
      
    }
}
