package JavaDoc;

import java.awt.Point;

/**
 * Simple circle class to do basic circle arithmetic
 * @author Adrian Colyer
 * @version 1.0
 */
public class Circle {

  /**
   * The radius of the circle
   */
  protected int radius;

  /**
   * The centre of the circle
   */
  protected Point centre;


  /**
   * Circle constructor to create a new instance of the circle class passing in
   * a radius and centre.
   */
  public Circle( Point centre, int radius ) {
    this.centre = centre;
    this.radius = radius;
  }


  /**
   * Calculate the circumference of the circle
   * @return the circumference
   * @see Circle#area
   */
  public double circumference( ) {
    return ( 2 * Math.PI * radius );
  }


  /**
   * Calculate the area of the circle.
   * @return the area
   * @see Circle#circumference
   */
  public double area( ) {
    return ( Math.PI * radius * radius );
  }


  /**
   * Set the centre of the circle.
   * @param x the x co-ordinate
   * @param y the y co-ordinate
   */
  public void setCentre( int x, int y ) {
   centre.x = x;
   centre.y = y;
  }


  /**
   * Set the radius of the circle.
   */
  public void setRadius( int r ) {
    radius = r;
  }


} // end of circle class