/******************************************************************************
// JsrUtil.java:   padLeft, padRight, string or integer input.
//                 output is padded or truncated as necessary.
 * Sample Use:
 * import JsrUtil;                  ... 
 * JsrUtil u = new JsrUtil();
 * paddedString  = u.padLeft(oldString,10);
 * paddedInteger = u.padLeft(oldInt,10);
 * zeroPadInt    = u.padZero(oldInt,10);
 * paddedString  = u.padRight(oldString,10);
 * dateTime      = u.getDateTime();
 * modString     = u.replaceAll(inString,fromString,toString);
 * int           = u.getInt(inString); // makes String an int.
 * 
*/
import java.util.*;

public class JsrUtil
{ 
  static final String COPYRIGHT = 
  "Copyright 1998, JSR Systems.  See: www.Jsrsys.com/copyright.";
  static final char[] blank = {' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
                               ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
                               ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
                               ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
                               ' ',' ',' ',' ',' ',' ',' ',' ',' ',' '};
                               // fifty (50) blanks for append...
                               
  public JsrUtil()  // null constructor
  {
  }

  String padLeft(String parmString, int parmLen)   
  {
     String       tempString;
     int          addLen;
     StringBuffer sb = new StringBuffer(parmLen);
     // set capacity of initial buffer to desired length!
     if (parmString.length()    > parmLen)
        tempString = parmString.substring(parmString.length()-parmLen,
                                          parmString.length());
     else
     {
        // tempString = parmString;
        // while (tempString.length() < parmLen)
        //   tempString = " "+tempString;
        addLen = parmLen - parmString.length();
        while (addLen > 50) // char[] array is only 50 blanks.
        {
          sb = sb.append(blank,0,50);
          addLen -= 50;
        } // now append final set of blanks w/ original string on end
        tempString = sb.append(blank,0,addLen).append(parmString).toString();
     }
     return tempString;  
  } 

  String padLeft(int parmInt, int parmLen)   
  {
     Integer tempInt    = new Integer(parmInt);
     String  tempString = tempInt.toString();
     int digitLen = tempString.length();
     int numComma = (digitLen-1) / 3;
     int addLen   = parmLen - digitLen - numComma;
     StringBuffer sb = new StringBuffer(parmLen);
     if (addLen > 0)
     {
        while (addLen > 50) // char[] array is only 50 blanks.
        {
          sb = sb.append(blank,0,50);
          addLen -= 50;
        } // now append final set of blanks w/ original string on end
        sb.append(blank,0,addLen).append(tempString); 
      }
      else sb.append(tempString);
      
     // System.out.println("d/n/a:"+digitLen+"/"+numComma+"/"+addLen+sb); 
     int commaPos = sb.length() - 3;
     while (numComma > 0)
     {
        sb.insert(commaPos,',');
        commaPos -= 3;
        numComma--;
     }
     // 2000-06-25 for integer input -only- put in ",".
     //            also, do not truncate if longer than parmLen!
     // return padLeft(tempString, parmLen);
     return sb.toString();
  } 

  String padZero(int parmInt, int parmLen)   
  {
     Integer tempInt    = new Integer(parmInt);
     String  tempString = tempInt.toString();
     if (tempString.length()    > parmLen)
        tempString = tempString.substring(tempString.length()-parmLen,
                                          tempString.length());
     else
     {
        while (tempString.length() < parmLen)
          tempString = "0"+tempString;
     }
     return tempString;  
  } 

  String padRight(String parmString, int parmLen)   
  {
     String       tempString;
     int          addLen;
     StringBuffer sb = new StringBuffer(parmLen);
     // set capacity of initial buffer to desired length!
     if (parmString.length()    > parmLen)
        tempString = parmString.substring(0,parmLen+1);
     else
     {
        //tempString = parmString;
        //while (tempString.length() < parmLen)
        //  tempString = tempString + " ";
        // 2000-06-24 replace above with following more efficient code
        // above code actualy generates:
        //  tempString = new StringBuffer().append(tempString).append(" ").toString();
        //  (i.e., a new StringBuffer is allocated, data is put into it,
        //         it is converted back to a string, for EACH character added)
        addLen = parmLen - parmString.length();
        sb = sb.append(parmString);
        while (addLen > 50) // char[] array is only 50 blanks.
        {
          sb = sb.append(blank,0,50);
          addLen -= 50;
        } // now append final set of blanks 
        tempString = sb.append(blank,0,addLen).toString();
     }
     return tempString;  
  } 

  String getDateTime()   
  {
      Calendar rightNow = Calendar.getInstance();
      String   today = rightNow.get(Calendar.YEAR)+"-"+
               padZero(rightNow.get(Calendar.MONTH)+1,2)+"-"+
               padZero(rightNow.get(Calendar.DAY_OF_MONTH),2)+"@"+
               padZero(rightNow.get(Calendar.HOUR_OF_DAY),2)+":"+
               padZero(rightNow.get(Calendar.MINUTE),2);
       // add 1 to month because Calendar returns 0 for January!!!
     return today;
  }

  // replaceAll() method modifies all occurences of "from" to "to"
  // special cases:  toString = '*delete*', newString='*delete* if find fromString
  //                 fromString ends in '=', replace text following '='
  //                        to first space, '>' or end-of-line.
  //                 example from: 'WIDTH=' to: ''
  //                         old:  'xxWIDTH=abc z'  becomes: 'xxz'
  String replaceAll(String oldString, String from, String to)
  {
    int lenFrom = from.length();
    int lenTo   =   to.length();
    String newSB = new String();
    char endFrom = from.charAt(lenFrom-1);
    char numChar = ' ';
    int where = 0;
    int last  = 0;
    int lenOld = oldString.length();
    where = oldString.indexOf(from);
    if (to.equals("*delete*") && where != -1)
       newSB = "*delete*";
    else
    {
     while (where != -1)
     {
       newSB = newSB+oldString.substring(last,where)+to;
       last  = where + lenFrom;
       if (endFrom == '=')
       {
          numChar = oldString.charAt(last);  
          while (numChar > ' ' && numChar != '>' && last < lenOld)
                 //  skip to next white space or '>' or end of line 
          {
            last++;
            numChar = oldString.charAt(last);  
            //System.out.println("numChar="+numChar);
          }
       }          
       where = oldString.indexOf(from,last);
     } 
     newSB = newSB+oldString.substring(last,lenOld);
    }
    return newSB;
  }
  //  end of replaceAll

  // getInt(String) -- so don't have to remember how to do it.
  int getInt( String parmNumber)   
  {
     Integer tempInt    = new Integer(parmNumber);
     return tempInt.intValue();
  }
  // end of getInt

} 