 /******************************************************************************
// JsrSysout.java:    
 * to simplify display/accept logic for debugging.
 * Sample Use:
 * import JsrSysout;                  ... 
 * JsrSysout sysout = new JsrSysout();  ...
 * sysout.display("Text to display");  // display line, stop at bottom of screen
 * sysout.accept ("Text to display");  // display line, wait for input.
 * sysout.speedometer("Text to display"); // display line, do NOT advance
 *                                        // next display (or spedometer) will
 *                                        // display in same space.
 * each instance of JsrSysout will save the last character entered from accept.
 * if that character is "q" (113), lower case q, subsequent calls to that
 *    instance will neither display (System.out.println), 
 *                      nor accept  (System.in.read()).     
 * 1998/08/18 modification.  If user enters "R" (for Run),
 *    displays will continue, but user will not be prompted for input.
 *
 * 1999-08-25 modifications:
 *    d.syslog("syslog.txt");  // will log to file syslog.txt.
 *    d.setNoStop();           // sets qBig to "R".
 *
 * 2000-06-25 add d.close() method so syslog can be closed if open.
 * 2000-07-11 add setFlush(true) call so syslog lines exist even if not closed
 *
*/

import java.io.*;
public class JsrSysout
{ 
  static final String COPYRIGHT = 
  "Copyright 1998-2000, JSR Systems.  See: www.Jsrsys.com/copyright.";

  static final int MAXLINELEN = 80;
  static final int MAXSCREEN  = 21;
  static int qBig = ' ';  //  81 "Q" to terminate all instances 
                          //  82 "R" run, do not query user any more
  int       qChar = ' ';  // 113 "q" to terminate this instance
  static int nLines = 0;
  static String   syslogFileName = "";
  // make syslog... static so any program can turn on logging of ALL calls 
  static JsrLineOut syslogFile = new JsrLineOut("NoLog");
  // any string in constructor will suppress recursive calls to JsrSysout
  //     this is a "special" option of JsrLineOut used  only by JsrSysout.

  JsrUtil u = new JsrUtil();  // for padRight method

  public JsrSysout()  // null constructor
  {
  }

  void display(String displayString)
  {  
     if (qChar != 113 && qBig != 81)
     {
        // System.out.println("Last q="+qChar+", Last Q="+qBig);
        nLines += (displayString.length()+MAXLINELEN)/MAXLINELEN;
        if (nLines > MAXSCREEN)
           accept(displayString);
        else   
        System.out.println(displayString);
        if (syslogFileName.length() > 0)
        {
            syslogFile.setLine(displayString);
        }
     }
     return;
  } 

  void accept(String displayString)
  {
     if (qChar != 113 && qBig != 81) 
     {
        // System.out.println("Last q="+qChar+", Last Q="+qBig);
        System.out.println(displayString);
        if (syslogFileName.length() > 0)
        {
            syslogFile.setLine(displayString);
        }
        nLines = (displayString.length()+MAXLINELEN)/MAXLINELEN;
        if (qBig != 82)
        {
          System.out.println("Waiting for input..."+
             "(Press [Enter], or \"q\", or \"Q\", "+
             "or \"R\", then [Enter].)");
          try {qChar = System.in.read();System.in.read();}
               catch (IOException eIO){}
          qBig = qChar;  // if "Q" will terminate all instances.
                         // if "q" will terminate this instance.
        }
     }
     return;
  }

  void speedometer(String displayString)
  {
     System.out.print(u.padRight(displayString,78)+"\r");
     System.out.flush();
  }
  
  void setNoStop()
  {
      qBig = 'R';
      return;
  }

  void syslog(String fileName)
  {
      syslogFileName = fileName;
      syslogFile.setName(fileName);
      syslogFile.setFlush(true);
      return;
  }

  void close()
  {
    if (syslogFileName != "")
      syslogFile.close();
    return;
  }
} 