import java.io.PrintWriter;
import java.io.FileWriter;
import java.io.IOException;

class JsrPrint1
{

  static final String COPYRIGHT = 
  "Copyright 1999, JSR Systems.  See: www.Jsrsys.com/copyright.";

  static    JsrSysout sysout = new JsrSysout();
  static    JsrUtil   u      = new JsrUtil();
  static    String[]  inputFile = {" ", " "};
  static    JsrLineIn input     = new JsrLineIn();
  static    int lineCount = 0;
  static    int pageCount = 0;
            // default printer is "old style" ASCII
  static    boolean hplj  = false;      // 17 cpi 
  static    boolean hplj20= false;      // 20 cpi 
  static    boolean hpdj  = false;      // 24 cpi 
  static    boolean brotherHL = false;  // 17 cpi
  static    boolean cc    = true;   // default is cc (nocc sets to false)
  static    String  ccChar = " ";  
  static    int linesPerPage = 60;
    public static void main(String parm[])
    {
      sysout.display("JsrPrint1--"+COPYRIGHT);
      sysout.display("JsrPrint1--usage: JsrPrint1 <input file> <printer/LPT1> <cc/nocc>");
      sysout.display("--------------------------- <hplj> <hplj20> <hpdj> <BrotherHL>");                
      if (parm.length < 2)
      {
        sysout.display("JsrPrint1--requires two parameters");
        return;
      }
      for (int i = 2; i < parm.length; i++)
      {
         if  (parm[i].equalsIgnoreCase("nocc"))
             cc = false;
         if  (parm[i].equalsIgnoreCase("hplj"))      // 17 cpi
             hplj = true;
         if  (parm[i].equalsIgnoreCase("hplj20"))    // 20 cpi
             hplj20 = true;
         if  (parm[i].equalsIgnoreCase("hpdj"))      // 24 cpi
             hpdj = true;
         if  (parm[i].equalsIgnoreCase("BrotherHL")) // 17 cpi
             brotherHL = true;
      }
          
      inputFile [0] = parm[0];
      sysout.display("Reading from: " + inputFile[0]);

      PrintWriter out;
      try
      {out = new PrintWriter(new FileWriter(parm[1]));
      } catch(IOException e) {sysout.display("Printer IO exception"+e);
                              return;
                             }
      sysout.display("Printing  to: " + parm[1]);
   
      if  (hplj20)                    // HP Laser Jet @ 20 cpi
      {
          out.print("\033E");         // Reset to defaults (for HP printers)
          out.print("\033&l8d&l88P"); // 8 lines per inch, 88 lpp
          out.print("\033&l4e&l80F"); // top margin 4 lines, 80 text lines
          out.print("\033(s0p(s20H"); // fixed pitch 20 char / inch
          out.print("\033(s0b(s6T");  // Normal strike wt. Letter Gothic typeface
          linesPerPage = 80;
      }
      else 
      if  (brotherHL || hplj)         // Brother HL-1040 Laser Jet or HPLJ @ 17 cpi
      {                               
          out.print("\033E");         // Reset to defaults (for HP printers)
          out.print("\033&l8d&l88P"); // 8 lines per inch, 88 lpp
          out.print("\033&l4e&l80F"); // top margin 4 lines, 80 text lines
          out.print("\033(s0p(s17H"); // fixed pitch 17 char / inch
          out.print("\033(s0b(s6T");  // Normal strike wt. Letter Gothic typeface
          linesPerPage = 80;
      }
      else 
      if  (hpdj)                      // HP Desk Jet
      {
          out.print("\033E");         // Reset to defaults (for HP printers)
          out.print("\033&l6d&l66P"); // 6 lines per inch, 66 lpp
          out.print("\033&l3e&l60F"); // top margin 3 lines, 60 text lines
          out.print("\033(s0p(s24H"); // fixed pitch 24 char / inch
          out.print("\033(s0b(s6T");  // Normal strike wt. Letter Gothic typeface
          out.print("\033*o-1M");     // EconoFast 300X300 dpi
          linesPerPage = 60;
      }
      else
      {
          out.print("\017");         // compressed print on Canon
          linesPerPage = 59;
      }

      int recNum = 0;
      while (0 <= (recNum=input.read(inputFile))) 
      {
        lineCount++;
        if (cc)
        {
           if (inputFile[1].length() < 2)
           {
              ccChar = " ";
              inputFile[1] = " ";
           }
           else
           {
              ccChar = inputFile[1].substring(0,1);
              inputFile[1] = inputFile[1].substring(1);
           }
           if (ccChar.equals("1"))
           {
              if (pageCount > 0 || lineCount > 1)
              {
                 out.print("\f"); // eject page
                 pageCount++;
                 lineCount--;
                 sysout.display("Printing page: "  +pageCount +
                               " (lines on page: "+lineCount+")");
                 lineCount = 1;
                 ccChar = " ";
              }
           }
      
        }

        if (cc && ccChar.equals("+")) lineCount--;
        if (cc && ccChar.equals("0")) lineCount++;
        if (cc && ccChar.equals("-")) lineCount+=2;

        // newpage if lineCount > linesPerPage, even if cc...
        if (lineCount > linesPerPage)
        {  pageCount++;
           out.print('\f'); // eject page
           lineCount--;
           sysout.display("Printing page: "+pageCount +
                         " (lines on page: "+lineCount+")");
           lineCount = 1;
        }
        if (cc)
        {
           if (ccChar.equals("+")) out.print("\r");
           else
           if (ccChar.equals("0")) out.print("\r\n\r\n");
           else
           if (ccChar.equals("-")) out.print("\r\n\r\n\r\n");
           else
                                   out.print("\r\n");
       
           out.print(inputFile[1]);
        }
        else   
           out.println(inputFile[1]);
   
      }

        // flush and check if we got any errors from those
        // print() and println() calls
        if (out.checkError()) {
            System.err.println("Got errors printing");
            System.exit(-1);
        }
        pageCount++;
        sysout.display("Printing page: "  +pageCount +
                      " (lines on page: "+lineCount+")");
        out.print('\f'); // eject page then close stream
        if  (hplj || hpdj || brotherHL || hplj20)
            out.print("\033E"); // Reset to defaults
        
        out.flush();    // not needed; close() will flush
        out.close();
    }
}