/******************************************************************************
// JsrLineOut.java:    
 * Sample Use:
 * JsrLineOut file1 = new JsrLineOut();
 * String[] strfile1[2];
 * strfile1[0] = "C:\reqlook.dxx"
 * file1.Write(strfile1[]))
 *
 *2000-06-25 add following methods to make more "object" like.
 * illustrated by "sample" use.
 * JsrLineOut file1 = new JsrLineOut();
 * String file1Name = "output.txt";
 * String file1Line;
 * ...
 * file1.write(file1Name, file1Line);
 *  // if file1Name is differnet from last method call
 *  //    open new file (close old if one is open).
 *
 *2000-07-11 add the following to make even more object like.
 * file1.setName(file1Name); // call once for each file
 * file1.setLine(file1Line); // call for each line to be written
 * file1.setFlush(true/false);  // if true cause flush() after each line written.
 * if (fileName.equals("")) fileName = lastName; //2000-07-28
*/

import java.io.*;

public class JsrLineOut
{ 
  static final String COPYRIGHT = 
  "Copyright 1998-2000, JSR Systems.  See: www.Jsrsys.com/copyright.";

  boolean               flushOn = false;
  int                   recNum = 0;
  String                fileName = "";
  String                lastName = "";
  
//1.0  DataOutputStream       outFileStream;
//1.0  DataOutput             outFile;
  BufferedWriter              outFile;
  JsrSysout sysout;
  boolean displayOn;
  JsrUtil       u = new JsrUtil();
  
  public JsrLineOut()  // null constructor
  {
     sysout = new JsrSysout();
     displayOn = true;
  }
  public JsrLineOut(String noLog)  // constructor to not log
  {  displayOn = false;            // used by JsrSysout itself
  }                                // to avoid recursive calls

  int open(String parmName)   
  {
     if (recNum != 0)
     {
        close();
     }
     if (displayOn) sysout.display("Open  Output: " + parmName);   
     // open code here
     fileName = parmName;
     recNum = 0;
//1.0try {outFileStream =
//1.0        new DataOutputStream(new FileOutputStream ( fileName));
//1.0     outFile =  outFileStream;
     try {outFile = new BufferedWriter(new OutputStreamWriter
                                      (new FileOutputStream (fileName)),1000000); 
         } catch ( IOException  eIO )
                 {System.out.println("I/OError! "   + fileName); 
                  recNum=-1; 
                 } 
     return recNum;
  } 
  int close()   
  {  
     if (recNum > 0)
     {
       if (displayOn)    
           sysout.display("Close Output: " + u.padLeft(recNum,10)
                        + " Records: "+ fileName  
                        +"                          ");   

//1.0  try {outFileStream.close();   // free up resource
       try {outFile.close();  // free up resource  
           }catch ( IOException  eIO )
                  {System.out.println("I/OError! "   + fileName); }
     }
     recNum   = - recNum;
     lastName = fileName; // save lastName if call w/o setName()
     fileName = "";
     return recNum;
  }
// 2000-07-11 add setName(String fileName) move file "open" check logic
//            add setLine(String fileLine) to do write.
  
  void setName(String parmName)
  {
     if (!parmName.equals(fileName))
     {
        open(parmName);
     }
  }
  int setLine(String parmLine)
  {
     if (recNum >= 0)
     {
       if (fileName.equals("")) fileName = lastName; //2000-07-28
       try { outFile.write(parmLine);
             outFile.newLine();  // platform dependent line separator
             if (flushOn) outFile.flush(); // flush after each line...
           } catch ( IOException  eIO )
                   {System.out.println("I/OError! "   + fileName); }
     }
     recNum++;
     return recNum;
  }
  void setFlush(boolean parmTF)
  {
    flushOn = parmTF;
  }
// 2000-06-25 add following "object" method.
// 2000-07-11 all code moved to setName/setLine().  
  int write(String parmName, String parmLine)
  {
    // if (displayOn) sysout.display("Write: " + parmName + parmLine);
    setName(parmName);
    return setLine(parmLine);
  }

// following is kept for backward compatability
  int write(String nameRecord[])   
  {
     // if (displayOn) sysout.display("Write: " + nameRecord[0] + nameRecord[1]);
     setName(nameRecord[0]);
     return setLine(nameRecord[1]);
  } 
} 