/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.GeneralPath;

public class JsrLinePlot
extends Frame
implements ItemListener,
ActionListener {
    static final String COPYRIGHT = "Copyright 2000, JSR Systems.  See: www.Jsrsys.com/copyright.";
    private String[] plotLabel;
    private int[][] plotValue;
    private String[] plotOrder;
    private int maxValue;
    private int numPoint;
    private int numLine;
    private int numPercent;
    static final Color[] lineColor = new Color[]{Color.red, Color.green, Color.blue, Color.orange, Color.pink, Color.yellow, Color.magenta, Color.cyan, Color.white};
    static float[][] dash = new float[][]{{30.0f, 5.0f, 20.0f, 15.0f}, {20.0f, 10.0f, 5.0f, 15.0f}, {10.0f, 20.0f, 15.0f, 5.0f}, {5.0f, 30.0f, 20.0f, 15.0f}};
    JsrUtil u = new JsrUtil();
    JsrSortString sortOrder = new JsrSortString();
    JsrSysout sysout = new JsrSysout();
    static final int DEFAULT_WIDTH = 2;
    static final int MAX_WIDTH = 100;
    static final int MIN_WIDTH = 1;
    private MenuBar menuBar;
    private Menu menuOptions;
    private Menu menuEndings;
    private Menu menuJoinings;
    private Menu menuWidths;
    private Menu menuRender;
    private Menu menuBeziers;
    private CheckboxMenuItem mitAntiAlias;
    private CheckboxMenuItem mitClosePath;
    private CheckboxMenuItem mitDashing;
    private CheckboxMenuItem mitOutline;
    private CheckboxMenuItem mitJoinMitre;
    private CheckboxMenuItem mitJoinBevel;
    private CheckboxMenuItem mitJoinRound;
    private CheckboxMenuItem mitEndNone;
    private CheckboxMenuItem mitEndRound;
    private CheckboxMenuItem mitEndSquare;
    private CheckboxMenuItem curEnding;
    private CheckboxMenuItem curJoining;
    private CheckboxMenuItem curShape;
    private CheckboxMenuItem curColor;
    private MenuItem mitIncrease;
    private MenuItem mitDecrease;
    private MenuItem mitMaximum;
    private MenuItem mitMinimum;
    private MenuItem mitDefault;
    private Menu menuBackCol;
    private CheckboxMenuItem mitColGray;
    private CheckboxMenuItem mitColBlack;
    private CheckboxMenuItem mitRenderQual;
    private CheckboxMenuItem mitRenderFast;
    private CheckboxMenuItem mitRenderDef;
    private boolean fAntiAlias;
    private boolean fClosePath;
    private boolean fDashing;
    private boolean fOutline;
    private boolean fControl;
    private int endStyle;
    private int joinStyle;
    private int lineWidth;
    private RenderingHints hints;
    private Font labelFont;
    private boolean selectSet;
    private Menu menuSelect;
    private MenuItem mitSelect;
    private String mitSelX = "*";
    private String[] selectItems = new String[0];
    private int lastDwidth;
    private int lastDheight;
    private int lastDx;
    private int lastDy;

    public JsrLinePlot(String s) {
        super(s);
        this.enableEvents(80L);
        this.addWindowListener(new WindowExit());
        this.labelFont = new Font("Comic Sans Ms", 1, 12);
        this.lastDwidth = 0;
        this.lastDheight = 0;
        this.lastDx = 0;
        this.lastDy = 0;
        this.menuBar = new MenuBar();
        this.selectSet = false;
        this.menuOptions = new Menu("Options");
        this.mitAntiAlias = new CheckboxMenuItem("Use Anti aliasing");
        this.mitAntiAlias.setState(true);
        this.mitClosePath = new CheckboxMenuItem("Close the path");
        this.mitDashing = new CheckboxMenuItem("Dashed lines");
        this.mitOutline = new CheckboxMenuItem("Draw outline");
        this.menuWidths = new Menu("Line Widths");
        this.mitIncrease = new MenuItem("Increase (+5)");
        this.mitDecrease = new MenuItem("Decrease (-5)");
        this.mitMaximum = new MenuItem("Maximum");
        this.mitMinimum = new MenuItem("Minimum");
        this.mitDefault = new MenuItem("Default");
        this.menuBackCol = new Menu("Background colour");
        this.mitColGray = new CheckboxMenuItem("Gray");
        this.mitColBlack = new CheckboxMenuItem("Black");
        this.menuBackCol.add(this.mitColBlack);
        this.menuBackCol.add(this.mitColGray);
        this.mitColBlack.addItemListener(this);
        this.mitColGray.addItemListener(this);
        this.menuRender = new Menu("Rendering");
        this.mitRenderDef = new CheckboxMenuItem("Default");
        this.mitRenderQual = new CheckboxMenuItem("Quality");
        this.mitRenderFast = new CheckboxMenuItem("Fastest");
        this.menuWidths.add(this.mitIncrease);
        this.menuWidths.add(this.mitDecrease);
        this.menuWidths.add(this.mitMaximum);
        this.menuWidths.add(this.mitMinimum);
        this.menuWidths.add(this.mitDefault);
        this.menuRender.add(this.mitRenderDef);
        this.menuRender.add(this.mitRenderQual);
        this.menuRender.add(this.mitRenderFast);
        this.menuOptions.add(this.mitAntiAlias);
        this.menuOptions.add(this.mitClosePath);
        this.menuOptions.add(this.mitDashing);
        this.menuOptions.add(this.mitOutline);
        this.menuOptions.add(this.menuWidths);
        this.menuOptions.add(this.menuRender);
        this.menuOptions.add(this.menuBackCol);
        this.mitAntiAlias.addItemListener(this);
        this.mitClosePath.addItemListener(this);
        this.mitDashing.addItemListener(this);
        this.mitOutline.addItemListener(this);
        this.mitIncrease.addActionListener(this);
        this.mitDecrease.addActionListener(this);
        this.mitMaximum.addActionListener(this);
        this.mitMinimum.addActionListener(this);
        this.mitDefault.addActionListener(this);
        this.mitRenderDef.addItemListener(this);
        this.mitRenderQual.addItemListener(this);
        this.mitRenderFast.addItemListener(this);
        this.menuEndings = new Menu("Endings");
        this.mitEndNone = new CheckboxMenuItem("None");
        this.mitEndSquare = new CheckboxMenuItem("Square");
        this.mitEndRound = new CheckboxMenuItem("Round");
        this.menuEndings.add(this.mitEndNone);
        this.menuEndings.add(this.mitEndSquare);
        this.menuEndings.add(this.mitEndRound);
        this.mitEndNone.addItemListener(this);
        this.mitEndSquare.addItemListener(this);
        this.mitEndRound.addItemListener(this);
        this.menuJoinings = new Menu("Joinings");
        this.mitJoinBevel = new CheckboxMenuItem("Bevel");
        this.mitJoinMitre = new CheckboxMenuItem("Mitre");
        this.mitJoinRound = new CheckboxMenuItem("Round");
        this.menuJoinings.add(this.mitJoinBevel);
        this.menuJoinings.add(this.mitJoinMitre);
        this.menuJoinings.add(this.mitJoinRound);
        this.mitJoinBevel.addItemListener(this);
        this.mitJoinMitre.addItemListener(this);
        this.mitJoinRound.addItemListener(this);
        this.menuBar.add(this.menuOptions);
        this.menuBar.add(this.menuEndings);
        this.menuBar.add(this.menuJoinings);
        this.setMenuBar(this.menuBar);
        this.fAntiAlias = true;
        this.fClosePath = false;
        this.fDashing = false;
        this.fOutline = false;
        this.fControl = true;
        this.endStyle = 1;
        this.joinStyle = 0;
        this.mitJoinMitre.setState(true);
        this.mitEndRound.setState(true);
        this.mitColBlack.setState(true);
        this.curEnding = this.mitEndRound;
        this.curJoining = this.mitJoinMitre;
        this.curColor = this.mitColBlack;
        this.lineWidth = 2;
        this.hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        this.mitRenderDef.setState(true);
    }

    public void paint(Graphics g) {
        Rectangle d = this.getBounds();
        Insets ins = this.getInsets();
        System.out.println("Size(x/y/w/h)/Insets(l/t/r/b)=" + d.x + "/" + d.y + "/" + d.width + "/" + d.height + "/" + ins.left + "/" + ins.top + "/" + ins.right + "/" + ins.bottom);
        this.lastDwidth = d.width;
        this.lastDheight = d.height;
        this.lastDx = d.x;
        this.lastDy = d.y;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setFont(this.labelFont);
        if (this.curColor.equals(this.mitColBlack)) {
            g2d.setColor(Color.black);
        } else {
            g2d.setColor(Color.lightGray);
        }
        g2d.fillRect(0, 0, d.width, d.height);
        if (this.fAntiAlias) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        long time1 = System.currentTimeMillis();
        int xStart = 100;
        int yStart = 100;
        float beginY = d.height * 15 / 16;
        float beginX = d.width * 1 / 16;
        float scaleX = d.width * 2 / 3 / this.numPoint;
        float scaleY = (beginY - 60.0f) / (float)this.maxValue;
        float thisX = 0.0f;
        float thisY = 0.0f;
        float lastY = 0.0f;
        int iOrder = this.numLine - 1;
        while (iOrder >= 0) {
            int i = this.u.getInt(this.plotOrder[iOrder].substring(10));
            if (this.mitSelX.equals("*") || this.mitSelX.equals(this.plotLabel[i].substring(0, this.mitSelX.length()))) {
                BasicStroke bs;
                GeneralPath path = new GeneralPath();
                path.moveTo(beginX, beginY);
                int b = 0;
                while (b < this.numPoint) {
                    thisX = beginX + scaleX * (float)(b + 1);
                    thisY = beginY - scaleY * (float)this.plotValue[i][b];
                    if (b == this.numPoint - 1) {
                        thisX -= scaleX * (float)(100 - this.numPercent) / 100.0f;
                    }
                    path.lineTo(thisX, thisY);
                    ++b;
                }
                if (this.fClosePath) {
                    path.closePath();
                }
                if (this.fDashing) {
                    int jDash = iOrder;
                    while (jDash >= dash.length) {
                        jDash -= dash.length;
                    }
                    bs = new BasicStroke(this.lineWidth, this.endStyle, this.joinStyle, 10.0f, dash[jDash], 0.0f);
                } else {
                    bs = new BasicStroke(this.lineWidth, this.endStyle, this.joinStyle);
                }
                int jColor = iOrder;
                while (jColor >= lineColor.length) {
                    jColor -= lineColor.length;
                }
                g2d.setColor(lineColor[jColor]);
                if (this.fOutline) {
                    g2d.draw(bs.createStrokedShape(path));
                } else {
                    g2d.setStroke(bs);
                    g2d.draw(path);
                }
                lastY = thisY <= lastY + 15.0f ? (lastY += 15.0f) : thisY;
                g2d.drawString(this.u.padLeft(this.plotValue[i][this.numPoint - 1], 5) + " " + this.plotLabel[i], thisX, lastY);
            }
            --iOrder;
        }
        long time2 = System.currentTimeMillis();
    }

    public void actionPerformed(ActionEvent aevt) {
        if (aevt.getSource() instanceof MenuItem) {
            MenuItem item = (MenuItem)aevt.getSource();
            if (item.equals(this.mitIncrease)) {
                this.lineWidth += 5;
                if (this.lineWidth >= 100) {
                    this.lineWidth = 100;
                }
            } else if (item.equals(this.mitDecrease)) {
                this.lineWidth -= 5;
                if (this.lineWidth <= 1) {
                    this.lineWidth = 1;
                }
            } else if (item.equals(this.mitMaximum)) {
                this.lineWidth = 100;
            } else if (item.equals(this.mitMinimum)) {
                this.lineWidth = 1;
            } else if (item.equals(this.mitDefault)) {
                this.lineWidth = 2;
            } else {
                String menuItem;
                this.mitSelX = menuItem = aevt.getActionCommand();
            }
        }
        this.repaint();
    }

    public void itemStateChanged(ItemEvent ievt) {
        if (ievt.getSource() instanceof CheckboxMenuItem) {
            CheckboxMenuItem item = (CheckboxMenuItem)ievt.getSource();
            if (item.equals(this.mitAntiAlias)) {
                this.fAntiAlias = item.getState();
            } else if (item.equals(this.mitClosePath)) {
                this.fClosePath = item.getState();
            } else if (item.equals(this.mitDashing)) {
                this.fDashing = item.getState();
            } else if (item.equals(this.mitOutline)) {
                this.fOutline = item.getState();
            } else if (item.equals(this.mitEndRound)) {
                this.curEnding.setState(false);
                this.endStyle = 1;
                this.curEnding = item;
                item.setState(true);
            } else if (item.equals(this.mitEndSquare)) {
                this.curEnding.setState(false);
                this.endStyle = 2;
                this.curEnding = item;
                item.setState(true);
            } else if (item.equals(this.mitEndNone)) {
                this.curEnding.setState(false);
                this.endStyle = 0;
                this.curEnding = item;
                item.setState(true);
            } else if (item.equals(this.mitJoinBevel)) {
                this.curJoining.setState(false);
                this.joinStyle = 2;
                this.curJoining = item;
                item.setState(true);
            } else if (item.equals(this.mitJoinMitre)) {
                this.curJoining.setState(false);
                this.joinStyle = 0;
                this.curJoining = item;
                item.setState(true);
            } else if (item.equals(this.mitJoinRound)) {
                this.curJoining.setState(false);
                this.joinStyle = 1;
                this.curJoining = item;
                item.setState(true);
            } else if (item.equals(this.mitRenderDef)) {
                this.hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
            } else if (item.equals(this.mitRenderQual)) {
                this.hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            } else if (item.equals(this.mitRenderFast)) {
                this.hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            } else if (item.equals(this.mitColBlack) || item.equals(this.mitColGray)) {
                this.curColor.setState(false);
                this.curColor = item;
                item.setState(true);
            }
            this.repaint();
        }
    }

    public void setFilter(String filterName, String[] lineSelect) {
        if (lineSelect.length > 0 && !this.selectSet) {
            this.selectSet = true;
            this.selectItems = lineSelect;
            this.menuSelect = new Menu(filterName);
            int i = 0;
            while (i < this.selectItems.length) {
                this.mitSelect = new MenuItem(this.selectItems[i]);
                this.mitSelect.addActionListener(this);
                this.menuSelect.add(this.mitSelect);
                ++i;
            }
            this.menuBar.add(this.menuSelect);
            this.setMenuBar(this.menuBar);
        }
    }

    public void drawLinePlot(String titleTxt, String[] lineLabel, int[][] lineValue, int lastPercent) {
        this.sysout.display("Enter JsrLinePlot: Len=" + lineLabel.length + "/" + lineValue.length + "/" + lineValue[0].length + "/" + "%=" + lastPercent + "/" + lineLabel[0]);
        this.setTitle(titleTxt);
        this.numPoint = lineValue[0].length;
        this.numPercent = lastPercent;
        this.numLine = lineValue.length;
        this.plotLabel = lineLabel;
        this.plotValue = lineValue;
        this.maxValue = 0;
        this.plotOrder = new String[this.numLine];
        int i = 0;
        while (i < this.numLine) {
            int b = 0;
            while (b < this.numPoint) {
                if (this.maxValue < this.plotValue[i][b]) {
                    this.maxValue = this.plotValue[i][b];
                }
                ++b;
            }
            this.plotOrder[i] = this.u.padZero(this.plotValue[i][this.numPoint - 1], 10) + this.u.padZero(i, 5);
            ++i;
        }
        try {
            this.sortOrder.sort(this.plotOrder);
        }
        catch (Exception Sort) {
            System.out.println("Sort Error in JsrLinePlot!");
        }
        Toolkit tlkt = Toolkit.getDefaultToolkit();
        Dimension dim = tlkt.getScreenSize();
        if (this.lastDwidth == 0) {
            this.lastDwidth = dim.width * 7 / 8;
        }
        if (this.lastDheight == 0) {
            this.lastDheight = dim.height * 7 / 8;
        }
        if (this.lastDx == 0) {
            this.lastDx = dim.width * 1 / 16;
        }
        if (this.lastDy == 0) {
            this.lastDy = dim.height * 1 / 16;
        }
        ((Component)this).setBounds(this.lastDx, this.lastDy, this.lastDwidth, this.lastDheight);
        this.show();
    }

    class WindowExit
    extends WindowAdapter {
        WindowExit() {
        }

        public void windowClosing(WindowEvent e) {
            Window w = e.getWindow();
            ((Component)w).setVisible(false);
            w.dispose();
            JsrLinePlot.this.sysout.display("JsrLinePlot--Exiting");
        }
    }
}

