/*  LogSplit  inputFile outputFile1 outputFile2 matchString
 *      read  inputFile
 *      write           outputFile1          if matchString is in line
 *      write                       outputFile2 if ...     not in line
 */
import java.io.*;  
public class LogSplit
{
  static final String COPYRIGHT = 
  "Copyright 1998, JSR Systems.  See: www.Jsrsys.com/copyright.";

  public static void  main(String argv[]) 
  {
    System.out.println("LogSplit--"+COPYRIGHT);

    LogSplit fixLine = new LogSplit();
    String    inputFile = argv[0];
    System.out.println("Input File:  *"+inputFile+"*");
    String   outputFile1 = argv[1];
    System.out.println("Output File1: "+outputFile1);
    String   outputFile2 = argv[2];
    System.out.println("Output File2: "+outputFile2);
    String   matchIt = argv[3];
    if (inputFile.equals("error.log")) matchIt = " "+ matchIt.substring(0,3) +" ";
        //  change matchIt string from Dec/1997 to " Dec ".
    System.out.println("Split String: *"+matchIt+"*");
    int      linesin = 0;
    int      lines100 = 0;
    int      lines1 = 0;
    int      lines2 = 0;
    try
    {
      DataInput   inFile = new DataInputStream (new FileInputStream ( inputFile));
      DataOutput outFile1 = new DataOutputStream(new FileOutputStream(outputFile1));
      DataOutput outFile2 = new DataOutputStream(new FileOutputStream(outputFile2));
      String     line;
      try { while ((line = inFile.readLine()) != null)
            {
              linesin++;
              lines100++;
              if (lines100 == 100)
              {
                 lines100 = 0;
                 System.out.print("Reading line: "+linesin+"\r");
                 System.out.flush();
              } 

              if (line.indexOf(matchIt) < 0)
              {
                  outFile2.writeBytes(line);
                  outFile2.writeBytes("\r\n");
                  lines2++;
              }
              else
              {
                  outFile1.writeBytes(line);
                  outFile1.writeBytes("\r\n");
                  lines1++;
              }
            }
          } catch (EOFException  eEOF) {System.out.println("EndOfFile!"); }
            catch ( IOException  eIO ) {System.out.println("I/OError! "); }
    } catch (FileNotFoundException eFNF) {System.out.println("FileNotFound");} 
      catch ( IOException  eIO ) {System.out.println("I/O or Output! "); }
    System.out.println("Lines with \""+matchIt+"\" on file "+outputFile1+": "+lines1);
    System.out.println("Lines w/o  \""+matchIt+"\" on file "+outputFile2+": "+lines2);
    System.out.println("LogSplit--"+COPYRIGHT);
  }
}
