/*  LogHTM    inputFile outputFile1  outputFile2 
 *      read  inputFile
 *      write           outputFile1          if ".htm" is in line
        write                        outputFile2 with counts by page 
 */
import java.io.*;  
import JsrSortString;
public class LogHTM
{
  static final String COPYRIGHT = 
  "Copyright 1998, JSR Systems.  See: www.Jsrsys.com/copyright.";
  static final int COUNTMAX = 300; // max entries in count Array

  public static void  main(String argv[]) 
  {
    System.out.println("LogHTM--"+COPYRIGHT);

    LogHTM fixLine = new LogHTM();
    String    inputFile = argv[0];
    System.out.println(" Input File: "+inputFile);
    String   outputFile1 = argv[1];
    System.out.println("Output File: "+outputFile1);
    String   outputFile2 = argv[2];
    System.out.println("Output File: "+outputFile2);
    String   matchIt = ".htm";
    System.out.println("Selecting:   "+matchIt+" log records.");
    int      linesin  = 0;
    int      lines100 = 0;
    int      lines1 = 0;
    String     htmName[] = new String[COUNTMAX];
               htmName[0] = "Total Hits...";
    int        htmCount[] = new   int[COUNTMAX];
               htmCount[0] = 0;
    int        htmIndex = 1;
    int        i = 1; 

    try
    {
      DataInput   inFile = new DataInputStream (new FileInputStream ( inputFile));
      DataOutput outFile1 = new DataOutputStream(new FileOutputStream(outputFile1));
      DataOutput outFile2 = new DataOutputStream(new FileOutputStream(outputFile2));
      String     line;
      String     whoLooked;
      String     dateLooked;
      String     htmLooked;
      String     resultHTM; 
      String     outLine;   
      int        index1, lenline1;
      try { while ((line = inFile.readLine()) != null)
            {
              linesin++;
              lines100++;
              if (lines100 == 100)
              {
                 lines100 = 0;
                 System.out.print("Reading line: "+linesin+"\r");
                 System.out.flush();
              } 

              if (line.indexOf(matchIt) >= 0)
              {
                  index1   = line.indexOf(" - - [");
                  lenline1 = line.length();          // 1998/07/04 add length check
                  if (index1 < 0 || (index1+35 > lenline1) ) 
                      System.out.println("Line skipped="+line);
                  else
                  {
                     whoLooked  = line.substring(0,index1);
                     dateLooked = line.substring(index1+6,index1+26);
                     htmLooked  = line.substring(index1+34);
                     resultHTM  = "     ";
                     index1     = htmLooked.indexOf(" "); // strip GET or HEAD...
                     if (index1 < 0) htmLooked = "                         "; 
                     else
                     {
                       htmLooked  = htmLooked.substring(index1+1);  
                       index1     = htmLooked.indexOf(" "); // find HTML tag
                       if (index1 >= 0) 
                       { 
                         resultHTM  = htmLooked.substring(index1+1);
                         htmLooked  = htmLooked.substring(0,index1);
                         index1     = resultHTM.indexOf(" "); 
                         resultHTM  = resultHTM.substring(index1+1);
                       }
                     }
                     while (htmLooked.length() < 25) htmLooked=htmLooked+" ";
                     outLine    = dateLooked+"+"+htmLooked+resultHTM+"<"+whoLooked+">";
                     outFile1.writeBytes(outLine);
                     outFile1.writeBytes("\r\n");
                     lines1++;
                     htmCount[0]++;
                     for (i=0; i < htmIndex; i++)
                     {
                        // System.err.println("i="+i+"htmIndex="+htmIndex+
                        //        htmLooked+"=="+htmName[i]+htmCount[i]);
                         if (htmLooked.equals(htmName[i]))
                         {
                            htmCount[i]++;
                            break;
                         }
                     }
                     // System.err.println("i="+i+"htmIndex="+htmIndex+
                     //            htmLooked);
                     // System.in.read();
                     if (i == htmIndex)   // not in array
                     {     
                         htmName[i]  = htmLooked;
                         htmCount[i] = 1;
                         htmIndex++;
                     } 
                  }
              }
            }
          } catch (EOFException  eEOF) {System.out.println("EndOfFile!"); }
            catch ( IOException  eIO ) {System.out.println("I/OError! "); }
          String[] countArray = new String[htmIndex];

          for (i = 0; i < htmIndex; i++)
          {
            Integer intCount = new Integer(htmCount[i]);   // convert integer to String
            String  strCount = intCount.toString();
            while (strCount.length() < 10) strCount = " "+strCount; // pad to 10 bytes
            countArray[i] = strCount +" accesses to: "+htmName[i];
          }
          JsrSortString sortIt = new JsrSortString();
          try {sortIt.sort(countArray);} 
              catch (Exception Sort) {System.out.println("Sort Error");}
 
          for (i=htmIndex-1; i >= 0; i--)
          {
            outFile2.writeBytes(countArray[i]);
            outFile2.writeBytes("\r\n");
          }


    } catch (FileNotFoundException eFNF) {System.out.println("FileNotFound");} 
      catch ( IOException  eIO ) {System.out.println("I/O or Output! "); }
    System.out.println("Lines with \""+matchIt+"\" on file "+outputFile1+": "+lines1);
    System.out.println("LogHTM--"+COPYRIGHT);
  }
}
