/*
 * JsrSortString    
 */
public class JsrSortString 
{
  static final String COPYRIGHT = 
  "Copyright 1998, JSR Systems.  See: www.Jsrsys.com/copyright.";
   /* This is a generic version of C.A.R Hoare's Quick Sort 
    * algorithm.  This will handle arrays that are already
    * sorted, and arrays with duplicate keys.
    *
    * @param a       a String array
    * @param lo0     left boundary of array partition
    * @param hi0     right boundary of array partition
    */
   void JsrQuickSort(String a[], int lo0, int hi0) throws Exception
   {
      int lo = lo0;
      int hi = hi0;
      String mid;

      if ( hi0 > lo0)
      {

         // Arbitrarily establishing partition element at the midpoint.
         mid = a[ ( lo0 + hi0 ) / 2 ];

         // loop through the array until indices cross
         while( lo <= hi )
         {
            // find the first element that is greater than or equal to 
            // the partition element starting from the left Index.
	     while( ( lo < hi0 ) && ( a[lo].compareTo(mid) < 0 ))
		 ++lo;

            // find an element that is smaller than or equal to 
            // the partition element starting from the right Index.
	     while( ( hi > lo0 ) && ( a[hi].compareTo(mid) > 0 ))
		 --hi;

            // if the indexes have not crossed, swap
            if( lo <= hi ) 
            {
               swap(a, lo, hi);
               ++lo;
               --hi;
            }
         }

         // If the right index has not reached the left side of array
         // must now sort the left partition.
         if( lo0 < hi )
            JsrQuickSort( a, lo0, hi );

         /* If the left index has not reached the right side of array
          * must now sort the right partition.
          */
         if( lo < hi0 )
            JsrQuickSort( a, lo, hi0 );

      }
   }

   private void swap(String a[], int i, int j)
   {
      String T;
      T = a[i]; 
      a[i] = a[j];
      a[j] = T;

   }

   public void sort(String a[]) throws Exception
   {
      JsrQuickSort(a, 0, a.length - 1);
   }
}
