/* JsrLoadArray 
 * JsrLoadArray loadIt = new JsrLoadArray(String inputFile, int arrMax);
 *        opens file inputFile, and allocates a temporary array[arrMax]).
 * 
 * loadIt.getEntry() copies  inputFile to the temporary array 
 * if an input line ends with a "-", the next line is read and
 *     appended to the target string (w/o the "-").
 * if it ends with --, then "--" -> "\r\n".
 *    for example:   line-  
 *                   next.     becomes linenext.
 *                   line--
 *                   next.     becomes line\r\nnext.
 * if arrMax is exceeded, extra elements are discarded, with error messages.
 *
 * after input is read, an array of exact # of array elements
 *    is allocated and returned.    
*/


public class JsrLoadArray
{
  static final String COPYRIGHT = 
  "Copyright 1998, JSR Systems.  See: www.Jsrsys.com/copyright.";
  static    JsrDebug debug = new JsrDebug();
  static    JsrUtil  u     = new JsrUtil();
  static    String[]  inputFile = {" ", " "};
  static    JsrLineIn   input = new JsrLineIn();
     int    recNum = 0;

  String[]        chgLine;
  int             arrayMax;
  JsrLoadArray(String parmFile, int arrMax)  // constructor opens file.
  {
    arrayMax = arrMax;
    chgLine  = new String[arrayMax];
    inputFile [0] = parmFile;  

  }
  String[] getEntry()  
  {
    int      lines = 0;
    String     line;
    int        lenLine;
     
    while (0 <= (recNum=input.Read(inputFile))) 
    {
       line = inputFile[1];
       if ( lines == 0) 
       { 
          chgLine[lines] = line;
          // System.out.println("chgLine="+lines+", "+line);
          lines++;
       } 
       else
       {
          lenLine = chgLine[lines-1].length(); 
          if (lenLine > 1 && chgLine[lines-1].charAt(lenLine-1) == '-')
          {
             if (chgLine[lines-1].charAt(lenLine-2) == '-')  // line ends with "--"
                chgLine[lines-1] = chgLine[lines-1].substring(0,lenLine-2)+"\r\n"+line;	
             else             
                chgLine[lines-1] = chgLine[lines-1].substring(0,lenLine-1)+line;	
                // System.out.println("Append="+chgLine[lines-1]);
          } 
          else
          {  if (lines < arrayMax)
             { 
                chgLine[lines] = line;
                // System.out.println("chgLine="+lines+", "+line);
                lines++;
             }
             else
             {
                System.out.println("Max input="+arrayMax+" discarded input="+line);
             } 
          }
       } 
    }
    if (lines > arrayMax)  lines = arrayMax;
    String[] newArray = new String[lines];
    for (int i=0; i < lines; i++)  newArray[i] = chgLine[i];
    return newArray;
  }
}
