//****************************************************************
// JsrList.java:   List (to disk) all files in directory.
//                 filename must contain args[0]  (i.e. "java")
//                 output will be "listed" to file args[1]. 
//****************************************************************
import java.io.*; 
import java.util.*;
import JsrDebug;
import JsrSortString;
public class JsrList 
{ 
  static final String COPYRIGHT = 
  "Copyright 1998, JSR Systems.  See: www.Jsrsys.com/copyright.";
    // JsrList Class Constructor
    //------------------------------------------------------------
    public JsrList()
    {
    }
    //------------------------------------------------------------
    public static void main(String args[])
    { JsrList JsrListC = new JsrList();
      JsrDebug debug = new JsrDebug();
      debug.display("JsrList--"+COPYRIGHT);
      if (args.length < 2)
      {  debug.display("JsrList--must contain two arguments:");
         debug.display("---------arg 1: file suffix (i.e., java)");
         debug.display("---------arg 2: target file for output.");
         return;
      }
      JsrSortString sortDir = new JsrSortString();
      String thisDir = System.getProperty("user.dir");
      debug.display("Current User Directory: "+thisDir);
      File listDir = new File(".");   // get current directory
      thisDir = listDir.getAbsolutePath();
      listDir = new File(thisDir);    // listDir is now full path
      thisDir = listDir.getParent();  // thisDir is just DirName
      String[] listFiles = listDir.list();
      int lenDir = listFiles.length;
      try {sortDir.sort(listFiles);} 
          catch (Exception Sort) {debug.display("Sort Error");}
      String   outputFile = args[1];
      System.out.println("JsrList----Output File: "+outputFile);
      try
      { DataOutputStream     outFileStream =
           new DataOutputStream(new FileOutputStream(outputFile));
        DataOutput outFile = outFileStream;
        // open stream separately so can close Stream
        int numSelected = 0;
        for (int i=0; i < lenDir; i++)
        {  if (listFiles[i].indexOf(args[0]) > 0 ) 
           {
             File thisFile = new File(listFiles[i]);
             if (thisFile.isFile()) 
             {
                 Long intCount = new Long(thisFile.length());
                 // int->String
                 String  strCount = intCount.toString();
                 while ((listFiles[i].length()+strCount.length()) < 25)
                         strCount = " "+strCount; 
                 Date thisDate = new Date(thisFile.lastModified());
                 String JsrTitle = listFiles[i]+strCount+" "+thisDate;
                 debug.display("JsrList-----Input File: "+JsrTitle);               
                 numSelected++;
                 debug.display("JsrList---Lines copied: "+
                   JsrListC.copyFile(listFiles[i], outFile, JsrTitle));
             }             
           }
        }
        outFileStream.close();
        debug.display("Directory "+thisDir+" Selected entries="+
                                   numSelected);
        debug.display("JsrList--"+COPYRIGHT);
      }catch (FileNotFoundException eFNF)
             {System.out.println("FileNotFound");} 
       catch ( IOException  eIO )
             {System.out.println("I/O or Output! ");}
    }

   int copyFile (String argv, DataOutput outFile, String JsrTitle) 
   {
     String    inputFile = argv;
     int lines = 0;
     try
     {
       DataInputStream     inFileStream =
          new DataInputStream (new FileInputStream ( inputFile));
       DataInput  inFile = inFileStream;
       String     line;
       outFile.writeBytes(JsrTitle+"\r\n");
       try { while ((line = inFile.readLine()) != null)
             { lines++;
               StringBuffer modLine = new StringBuffer(line);
               Integer intLines = new Integer(lines);
               String  strLines = intLines.toString();
               while (strLines.length() < 3) strLines = " "+strLines;
               outFile.writeBytes(strLines+": ");
               outFile.writeBytes(modLine.toString());
               outFile.writeBytes("\r\n");
             }
             inFileStream.close();  // free up resource 
           } catch (EOFException  eEOF)
                   {System.out.println("EndOfFile!"); }
             catch ( IOException  eIO )
                   {System.out.println("I/OError! "); }
     } catch (FileNotFoundException eFNF)
             {System.out.println("FileNotFound");} 
       catch ( IOException  eIO )
             {System.out.println("I/O or Output! "); }
     return lines;
   }
}
