/******************************************************************************
// JsrLineOut.java:    
 * Sample Use:
 * import JsrLineOut;                  ... 
 * JsrLineOut file1 = new JsrLineOut();
 * String[] strfile1[2];
 * strfile1[0] = "C:\reqlook.dxx"
 * file1.Write(strfile1[]))
*/

import java.io.*;
import JsrDebug;
public class JsrLineOut
{ 
  static final String COPYRIGHT = 
  "Copyright 1998, JSR Systems.  See: www.Jsrsys.com/copyright.";

  int                   recNum = 0;
  String                fileName = "";
  DataOutputStream       outFileStream;
  DataOutput             outFile;
  JsrDebug debug = new JsrDebug();

  public JsrLineOut()  // null constructor
  {
  }

  int Open(String parmName)   
  {
     if (recNum != 0)
     {
        Close();
     }
     debug.display("Open  Output: " + parmName);   
     // open code here
     fileName = parmName;
     recNum = 0;
     try {outFileStream =
             new DataOutputStream(new FileOutputStream ( fileName));
          outFile =  outFileStream;
         } catch ( IOException  eIO )
                 {System.out.println("I/OError! "   + fileName); 
                  recNum=-1; 
                 } 
     return recNum;
  } 
  int Close()   
  {  
     if (recNum > 0)
     {
       debug.display("Close Output: " + fileName + " Records out=" + recNum);   
       try {outFileStream.close();   // free up resource
           }catch ( IOException  eIO )
                  {System.out.println("I/OError! "   + fileName); }
     }
     recNum   = - recNum;
     fileName = "";
     return recNum;
  } 
  int Write(String nameRecord[])   
  {
     // debug.display("Read: " + nameRecord[0] + nameRecord[1]);   
     if (!nameRecord[0].equals(fileName))
     {
        Open(nameRecord[0]);
     }
     if (recNum >= 0)
     {
       try { outFile.writeBytes(nameRecord[1]+"\r\n");
           } catch ( IOException  eIO )
                   {System.out.println("I/OError! "   + fileName); }
     }
     recNum++;
     return recNum;
  } 
} 

