/******************************************************************************
// JsrLineIn.java:    
 * to simplify display/accept logic for debugging.
 * Sample Use:
 * import JsrLineIn;                  ... 
 * JsrLineIn file1 = new JsrLineIn();
 * String[] strfile1[2];
 * strfile1[0] = "C:\reqlook.dxx"
 * while (0 <= file1.read(strfile1[]))
      {   process records from strfile1[1];           }
*/

import java.io.*;
import JsrDebug;
public class JsrLineIn
{ 
  static final String COPYRIGHT = 
  "Copyright 1998, JSR Systems.  See: www.Jsrsys.com/copyright.";

  int                   recNum = 0;
  String                fileName = "";
  DataInputStream       inFileStream;
  DataInput             inFile;
  JsrDebug debug = new JsrDebug();

  public JsrLineIn()  // null constructor
  {
  }

  int Open(String parmName)   
  {
     if (recNum != 0)
     {
        Close();
     }
     debug.display("Open   Input: " + parmName);   
     // open code here
     fileName = parmName;
     recNum = 0;
     try {inFileStream =
             new DataInputStream(new FileInputStream ( fileName));
          inFile =  inFileStream;
         } catch (FileNotFoundException eFNF)
                 {System.out.println("FileNotFound: " + fileName);
                  recNum=-1; 
                 } 
     return recNum;
  } 
  int Close()   
  {  
     debug.display("Close  Input: " + fileName + " Records in=" + recNum);   
     if (recNum >= 0)
     {
       try {inFileStream.close();   // free up resource
           }catch ( IOException  eIO )
                  {System.out.println("I/OError! "   + fileName); }
     }
     recNum   = - recNum;
     fileName = "";
     return recNum;
  } 
  int Read(String nameRecord[])   
  {
     // debug.display("Read: " + nameRecord[0] + nameRecord[1]);   
     if (!nameRecord[0].equals(fileName))
     {
        Open(nameRecord[0]);
     }
     if (recNum >= 0)
     {
       try {nameRecord[1] = inFile.readLine();
           } catch (EOFException  eEOF)
                   {System.out.println("EndOfFile!: " + fileName); }
             catch ( IOException  eIO )
                   {System.out.println("I/OError! "   + fileName); }
       if (nameRecord[1] == null)
          Close();
       else
          recNum++;
     }
     return recNum;
  } 
} 

