//******************************************************************************
// JsrEdit.java:  Application
// JsrEdit will apply Edit fromTo strings read from file arg[0]
// the fromTo are read as pairs, to delete a string the second line is null.
//     if to line == *delete*, then the whole line containing from string
//            will be deleted.
// if an input line ends with a "-", the next line is read and
//     appended to the target string (w/o the "-").
// if it ends with --, then it becomes line\r\nnextline.  (i.e. "--" -> \r\n).
//    for example:   line-  
//                   next.     becomes linenext.
//                   line--
//                   next.     becomes line\r\nnext.
// the input file is specified from the panel.
// after the edits the input file is renamed to *.$$$
//     for example:  week03.htm becomes week03.$$$, afile becomes afile.$$$
// a temporary file "JsrEdit.$$$" is used for intermediate output.  
//******************************************************************************
import java.applet.*;
import java.awt.*;
import java.io.*;
import JsrLoadArray;    // loads fromTo array, appending "-" and "--" lines. 
//==============================================================================
// Main Class for applet JsrEdit
//==============================================================================
public class JsrEdit extends Applet
{   
  static final String COPYRIGHT = 
  "Copyright 1998, JSR Systems.  See: www.Jsrsys.com/copyright.";
        static Label      inDirLabel;
        static Label      inLabel;
        static TextField  inText; 
        static Label     outLabel;
        static Label     outText; 
        static Label     recText; 
        static Button    copyButton, exitButton;
        static int       fromToMax;
        static String[]  fromTo;
        static int       qChar   = ' ';  // 113 "q" to terminate input pause
        Frame  frame; 

    //--------------------------------------------------------------------------
    public static void main(String args[])
    {
        JsrEdit JsrEditC = new JsrEdit();
        System.out.println("JsrEdit--"+COPYRIGHT);

        JsrEditC.frame = new Frame("JsrEdit");
        // Must show Frame before we size it so insets() will return valid values
        //----------------------------------------------------------------------
        JsrEditC.frame.show();
        JsrEditC.frame.hide();
        JsrEditC.frame.resize(JsrEditC.frame.insets().left + 
                              JsrEditC.frame.insets().right  + 400,
                              JsrEditC.frame.insets().top  + 
                              JsrEditC.frame.insets().bottom + 200);

        JsrLoadArray fromToFile = new JsrLoadArray(args[0], 100);
        fromTo    = fromToFile.getEntry();
        fromToMax = fromTo.length;
        System.out.println("Number fromTo Pairs="+fromToMax+"/2"+
                           " Max array size=100");
        
        JsrEditC.frame.add("Center", JsrEditC);
        JsrEditC.init();
        JsrEditC.frame.show();
    }

    // JsrEdit Class Constructor
    //--------------------------------------------------------------------------
    public JsrEdit()
    {
        // TODO: Add constructor code here
    }

    //--------------------------------------------------------------------------
    public void init()
    {
        String    inDirectory, inDirLabelText;
        inDirectory = System.getProperty("user.dir");
        System.out.println("Current User Directory: "+inDirectory);

        setLayout(new FlowLayout(FlowLayout.LEFT,10,10));
        inDirLabel = new Label("                                    ");
        inLabel  = new Label(" Input File:");
        inText   = new TextField(40); 
        outLabel = new Label("Backup File:");
        outText  = new Label("                                       "); 
        recText  = new Label("Press Copy Button to copy file         ");
        copyButton = new Button("Copy");
        exitButton = new Button("Exit");

        add (inDirLabel);
        add (inLabel);
        add (inText);
        add (outLabel);
        add (outText);
        add (copyButton);
        add (exitButton);
        add (recText);
        inText.requestFocus();
        inDirLabelText = "Current User Directory: "+inDirectory;
        while (inDirLabelText.length() < 100) 
               inDirLabelText=inDirLabelText+" ";
        inDirLabel.setText(inDirLabelText);

    }

    public boolean action(Event event, Object arg)
    {
       String inputFileName;
       String bakFileName;
       int    whereDot;
       if (event.target instanceof Button && arg.equals("Copy"))
       {
          inputFileName = inText.getText();
          File testFile = new File(inputFileName);
          if (testFile.exists()) 
          {
             whereDot = inputFileName.indexOf(".");
             if (whereDot > 0)
                bakFileName = inputFileName.substring(0,whereDot) + ".$$$";
             else
                bakFileName = inputFileName + ".$$$"; 
             outText.setText(bakFileName);
             recText.setText("Lines copied: "+ 
                     JsrEdit.copyFile(inputFileName, bakFileName, "JsrEdit.$$$"));
             exitButton.requestFocus();
          }
          else
          {
             recText.setText("File: " + inputFileName + " does not exist"); 
             inText.requestFocus();
          } 
       }
        if (event.target instanceof Button && arg.equals("Exit"))
       {
          System.out.println("JsrEdit--"+COPYRIGHT);

          recText.setText("Exiting...");
          frame.dispose();
          System.exit(0);
       }
      return true;
    }  



    // JsrEdit Paint Handler
    //--------------------------------------------------------------------------
    public void paint(Graphics g)
    {
        g.drawString("   ", 10, 20);
    }

  // the newString() method modifies all occurences of "from" to "to"
  String newString(String oldString, String from, String to)
  {
    int lenFrom = from.length();
    int lenTo   =   to.length();
    String newSB = new String();
    char endFrom = from.charAt(lenFrom-1);
    char numChar = ' ';
    int where = 0;
    int last  = 0;
    int lenOld = oldString.length();
    where = oldString.indexOf(from);
    // System.out.println("where="+where+" from=*"+from+"*to=*"+to+" line="+oldString);
    // if (qChar != 113 ) // 113 == 'q', 10, 13 == Enter...
    // {try {qChar = System.in.read();} catch (IOException eIO){}  }
    if (to.equals("*delete*") && where != -1)
       newSB = "*delete*";
    else
    {
     while (where != -1)
     {
       //System.out.println("last: "+last+" where: "+where+"end="+endFrom);
       newSB = newSB+oldString.substring(last,where)+to;
       //System.out.println(newSB);
       last  = where + lenFrom;
       if (endFrom == '=')
       {
          numChar = oldString.charAt(last);  
          while (numChar >= ' ' && numChar != '>' && last < lenOld)
                 //  skip to next white space or '>' or end of line 
          {
            last++;
            numChar = oldString.charAt(last);  
            //System.out.println("numChar="+numChar);
          }
       }          
       where = oldString.indexOf(from,last);
     } 
     //System.out.println("last: "+last+" where: "+where);
     newSB = newSB+oldString.substring(last,lenOld);
    }
    // System.out.println("newSB=*"+newSB+"*");
    return newSB;
  }

  // the copyFile method  1) copies  inputFile to  tempFile (with changes) 
  //                      2) renames inputFile to   bakFile 
  //                      3) renames tempFile  to inputFile 
  int  copyFile(String inputFile, String bakFile, String tempFile) 
  {
    String   outputFile = tempFile;
    String     thisDir;
    int      lines = 0;
    try
    {
      DataInputStream       inFileStream = 
                     new DataInputStream(new FileInputStream ( inputFile));
      DataOutputStream     outFileStream = 
                    new DataOutputStream(new FileOutputStream(outputFile));
      DataInput   inFile =  inFileStream;
      DataOutput outFile = outFileStream;
      String     line;
      try { while ((line = inFile.readLine()) != null)
            {
              for (int i=1;i<fromToMax;i+=2)  // 1 to max so ending odd line will be skipped
              { 
                  line = JsrEdit.newString(line,fromTo[i-1],fromTo[i]);
                  // line = JsrEdit.newString(line,"\\r\\n","\r\n"); 
                  // this is now done in loadFile...  
                  // "--" at end of line becomes \r\n + next line.  
              }
              if (!(line.equals("*delete*")))
              {
                 outFile.writeBytes(line);
                 outFile.writeBytes("\r\n");
              }
              lines++;
            }
          } catch (EOFException  eEOF) {System.out.println("EndOfFile!: "+ inputFile); }
            catch ( IOException  eIO ) {System.out.println("I/OError! "); }
      inFileStream.close();   // free up resource prior to rename
      outFileStream.close();
    } catch (FileNotFoundException eFNF) {System.out.println("FileNotFound");} 
      catch ( IOException  eIO ) {System.out.println("I/O or Output! "); }

    File   inFD = new File(inputFile);
    File  bakFD = new File(bakFile);
    File tempFD = new File(tempFile);
    System.out.println("copy " +inputFile+ " to " +tempFile+ " rename to " +bakFile);
    if (bakFD.exists() == true) 
        System.out.println("delete "         + bakFD+"=" + bakFD.delete());
    System.out.println("rename "+inFD+ " to "+ bakFD+"=" + inFD.renameTo(bakFD));
    System.out.println("rename "+tempFD+" to " +inFD+"=" + tempFD.renameTo(inFD));  
 
    return lines;
  }
}
