/* ****************************************************************************
 * JsrDump.java:    Application
 *  see help[] for details.
 ******************************************************************************
 */
import java.awt.*;
import java.io.*; 
import java.util.*;
import JsrDebug;
//==============================================================================
public class JsrDump
{ 
  static final String COPYRIGHT = 
  "Copyright 1998, JSR Systems.  See: www.Jsrsys.com/copyright.";
  static final String[] HELP = 
  {
  "JsrDump.java:    Application",
  "dump selected file, line1 = code line, line2=printable ASCII code.",
  "line1: values:  line2:",
  "    ^ (  0- 31) ascii ctrl character (0-31) add 64 to print.",
  "    . ( 32-126) ascii printable characters.",
  "    | (    127) print \"|\".",
  "    ! (128-159) add 128 + 64 to print.",
  "    + (160-254) add 128      to print.",
  "    + (    255) print \"|\".",
  "For each screen, JsrDump requests input, displays remaining bytes.",
  "[Enter] will continue, \"q\" or \"Q\" then [Enter] will quit dump."
  };

  static final int MAXCHAR = 78;
  static final int MAXLINE = 10;  
  static final String SCALELINE = 
  "....+....1....+....2....+....3....+....4....+....5....+....6....+....7....+678";
  //--------------------------------------------------------------------------
  public static void main(String args[])
  { 
    JsrDump JsrDumpC = new JsrDump();
    String inFDName, inDirName;  
    // JsrDebug debug   = new JsrDebug();
    //for (int i = 0; i < args.length; i++)
    //{
    //  debug.display("Args["+i+"]="+args[0]+"*"); 
    //}
    if (args.length < 1)
    {
      //debug.display("Creating Dialog");
      Frame JsrFrame = new Frame();
      FileDialog inFileDiag;
      inFileDiag = new FileDialog(JsrFrame, "Select File to Dump", FileDialog.LOAD);
      inFileDiag.show();
      inFDName  = inFileDiag.getFile();
      inDirName = inFileDiag.getDirectory();
      JsrFrame.dispose();
    }
    else
    {
      inFDName  = args[0];
      inDirName = "";
    }
    File thisFile = new File(inFDName);
    long fileSize = thisFile.length();
    Long intLength = new Long(fileSize); // convert integer to String
    String  strLength = intLength.toString();
    Date thisDate = new Date(thisFile.lastModified());
    String JsrTitle1=inDirName + 
           inFDName+" Length="+strLength+" Mod: "+thisDate;  
    String JsrTitle2="        "+COPYRIGHT;
    System.out.println(JsrTitle1);
    System.out.println(JsrTitle2);
    System.out.println(SCALELINE);
    JsrDumpC.dumpFile(inFDName, fileSize, JsrTitle1, JsrTitle2);
    System.exit(0);
  }

  // JsrDump Class Constructor
  //--------------------------------------------------------------------------
  public JsrDump()
  {
  }

  // the dumpFile method  1) copies  inputFile 
  void dumpFile(String inputFile, long fileSize, String JsrTitle1, String JsrTitle2) 
  {
    int      qChar = 0;
    int      chars = 0;
    int      lines = 0;
    long     fileChar= 0;
    long     fileRemain = fileSize;
    // JsrDebug debug = new JsrDebug();
    try
    {
      DataInputStream       inFileStream = 
                     new DataInputStream (new FileInputStream ( inputFile));
      DataInput   inFile =  inFileStream;

      String     line1   = new String("");
      String     line2   = new String("");
      String     strChar;
      int        intVal;
      //byte       bChar   = -128;
      byte[]     lineChar = {0}; 
      //fileSize = 256;
      try { while (fileChar < fileSize && qChar != 81 && qChar != 113)
            {                                   //  Q              q
              fileChar++;
              lineChar[0] = inFile.readByte();
              //lineChar[0] = bChar; 
              //bChar++;
              intVal      = lineChar[0];
              strChar     = new String(lineChar);
              //   debug.accept("Reading Byte="+fileChar+"="+intVal+
              //      "="+strChar);
            
              if (lineChar[0] < -96)
              {
                 line1 += "!";
                 lineChar[0] += 192;  // 128 + 64 = 192
                 strChar = new String(lineChar);
                 line2 += strChar;
              }
              else if (lineChar[0] < -1) 
              {
                 line1 += "+";
                 lineChar[0] += 128;
                 strChar = new String(lineChar);
                 line2 += strChar;
              }
              else if (lineChar[0] == -1) 
              {
                 line1 += "+";
                 line2 += "|";
              }
              else if (lineChar[0] < 32)
              {
                 line1 += "^";
                 lineChar[0] += 64;
                 strChar = new String(lineChar);
                 line2 += strChar;
              }
              else if (lineChar[0] < 127) 
              {
                 line1 += ".";
                 strChar = new String(lineChar);
                 line2 += strChar;
              }
              else if (lineChar[0] == 127) 
              {
                 line1 += "|";
                 line2 += "|";
              }
              //debug.display(line1);
              //debug.display(line2);
              chars++;
              if (chars == MAXCHAR)
              {
                  System.out.println(line1);
                  System.out.println(line2);
                  chars = 0;
                  line1 = "";
                  line2 = "";
                  lines++; 
                  if (lines == MAXLINE)
                  {
                    fileRemain = fileSize - fileChar;
                    System.out.println("JsrDump-Waiting...(Press [Enter], \"q\", or \"Q\")"
                                       +" Remaining bytes="+fileRemain);
                    try {qChar = System.in.read(); System.in.read();} catch (IOException eIO){}
                    lines = 0;
                    System.out.println(JsrTitle1);
                    System.out.println(JsrTitle2);
                    System.out.println(SCALELINE);

                  }
              }
            }
            System.out.println(line1);
            System.out.println(line2);
            System.out.println(JsrTitle1);
            System.out.println(JsrTitle2);
            System.out.println(SCALELINE);
            if (lines < (MAXLINE - 6))
               for(int i=0; i<11; i++) System.out.println(HELP[i]);

          } catch (EOFException  eEOF) {System.out.println("EndOfFile!"); }
            catch ( IOException  eIO ) {System.out.println("I/OError! "); }
      inFileStream.close();   // free up resource prior to rename
    } catch (FileNotFoundException eFNF) {System.out.println("FileNotFound");} 
      catch ( IOException  eIO ) {System.out.println("I/O on Output! "); }
  
    return;
  }

}
