//******************************************************************************
// JsrDir.java:    Sorted directory listing.
//                 If args[0] not null, filename must contain args[0]
//******************************************************************************
import java.io.*; 
import java.util.*;
import JsrDebug;
import JsrSortString;
public class JsrDir 
{ 
  static final String COPYRIGHT = 
  "Copyright 1998, JSR Systems.  See: www.Jsrsys.com/copyright.";
    // JsrDir Class Constructor
    //--------------------------------------------------------------------------
    public JsrDir()
    {
    }
    //--------------------------------------------------------------------------
    public static void main(String args[])
    { 
      JsrDebug debug = new JsrDebug();
      debug.display("JsrDir--"+COPYRIGHT);
      debug.display("JsrDir--usage: JsrDir <filter> <full path name>");
      JsrSortString sortDir = new JsrSortString();
      String thisDir = System.getProperty("user.dir");
      debug.display("Current User Directory: " + thisDir);
      String lookDir = thisDir;
      if (args.length >= 2)
      {
         lookDir = args[1];
         debug.display("      Search Directory: " + lookDir);
      }
      File listDir = new File(lookDir);   // get current directory
      thisDir = listDir.getAbsolutePath();
      //listDir = new File(thisDir);        // listDir is now full path
      //thisDir = listDir.getParent();      // thisDir is string of just DirName
      String[] listFiles = listDir.list();
      int lenDir = listFiles.length;
      debug.display("             Directory: " + thisDir
                  + " (# entries=" + lenDir    + ")");
      try {sortDir.sort(listFiles);} 
          catch (Exception Sort) {debug.display("Sort Error");}
      int numSelected = 0;
      for (int i=0; i < lenDir; i++)
      {  if ((args.length == 0)        ||
             (args[0].length() == 0)   ||
             (listFiles[i].toLowerCase().indexOf(args[0].toLowerCase()) > 0 )) 
         {
           // debug.display("thisDir: "+thisDir);     
           File thisFile = new File(thisDir+"\\"+listFiles[i]);
           if (thisFile.isFile()) 
           { 
               Long intCount = new Long(thisFile.length()); // integer->String
               String  strCount = intCount.toString();
               while ((listFiles[i].length()+strCount.length()) < 25)
                       strCount = " "+strCount; 
               Date thisDate = new Date(thisFile.lastModified());
               debug.display("File: "+listFiles[i]+strCount+" "+thisDate);
           }             
           else
           if (thisFile.isDirectory())   
               debug.display("Dir:  "+listFiles[i]);
           else
               debug.display("???:  "+thisDir+"\\"+listFiles[i]);
           numSelected++;
         } 
      }
      debug.display("             Directory: " + thisDir
               +" (# selected=" + numSelected  +")");
      debug.display("JsrDir--"+COPYRIGHT);
    }
}
