// JsrVote.java
//
//  2000-02-15 changes:
//  add logic for multiple races
//
//  Assumptions:  the following are assumed to exist, current version has
//  no error checking, it just assumes these states.
//  1)  p1+i.txt exists and is well formed (see share93i.txt for example).
//      in particular # races, and # candidates is critical.
//  2)  race title lines are in format ## title (## is max votes this race).
//  3)  candidate  lines are in format (k) Name (k is shortcut key).
//  4)  current version only supports one race, extra loop logic will be added.
//      however [race] variables are all arrays, only loop logic is missing.
//  5)  p1+v.txt is assumed to always exist.
//      first line is assumed to be titles (for Excel).
//      first action (ALWAYS) is to rename p1+v.txt to p1+v.$$$
//      then program reads p1+v.$$$, copying to p1+v.txt,
//      building vote count (batch and total) arrays.
//  6)  after initial run, contents of p1+i.txt must NOT be changed, except:
//      title line, maximum batches (used for array size calculation), and
//      batch size may be changed.
//  7)  each ballot voted is immediately written to p1+v.txt, so recovery
//      is always to last ballot voted.  However, ballot # is part of data
//      so recovery could be modified by editing p1+v.txt file.

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.File;
import java.util.*;


public class JsrVote
{
  static final String COPYRIGHT = 
  "Copyright 2000, JSR Systems.  See: www.Jsrsys.com/copyright.";
  static JsrSysout  d = new JsrSysout();
  static JsrUtil    u = new JsrUtil();
  // static Font defaultFont = new Font("Lucida Sans",Font.BOLD,18);        
  static Font defaultFont = new Font("Comic Sans MS",Font.BOLD,18);        

  static String[] inputFile = {" ", " "};
  static JsrLineIn input = new JsrLineIn();

  static String[] outputFile = {" ", " "};
  static JsrLineOut output = new JsrLineOut();

  static String[] reportFile = {" ", " "};
  static JsrLineOut report = new JsrLineOut();

  static String[]  print1Parm = new String[] {"*r.txt", "LPT1", "cc", " "};
  static JsrPrint1 print1     = new JsrPrint1();
  static int       printLPP   = 66;  // lines per page
  static int       lineCount  = 999; // line count to force immediate page break
  
  static String voteTitle;     // Title         (card input)
  static int    maxBatch  = 0; // max # batches (card input)
  static int    batchSize = 0; // batch size    (card input)
  static int    maxRace   = 0; // max # Races   (card input)
  static int    maxVote   = 0; // max # Votes   (card input, all Races)
  static JLabel batHead     = new JLabel("Batch #  1 ",SwingConstants.RIGHT);
  static JLabel totHead     = new JLabel("Vote Totals",SwingConstants.RIGHT);
  static JLabel dotLabel1   = new JLabel("Race(s) & Candidates",SwingConstants.LEFT);
  static JLabel dotLabel2   = new JLabel("   ",SwingConstants.RIGHT);
  static JLabel dotLabel3   = new JLabel("   ",SwingConstants.RIGHT);
  static JLabel batSumLabel = new JLabel("Batch: xxxxxxxxx",SwingConstants.RIGHT);
  static JLabel totSumLabel = new JLabel("Total: xxxxxxxxx",SwingConstants.RIGHT);

  // for following arrays, actual allocation size will be determined in main
  static int[]    voteMax;   // Max # votes/Race (card input)
  static String[] raceName;  // Race Name        (card input)
  static String[] voteName;  // Candidate name   (card input)
                             // (#) name... where # is selection key (sets box true)
  static int[]    raceVotes; // # votes this Ballot by Race
  static int[]    voteCount; // # votes by candidate
  static int[]    cummCount; // cumm votes for All Batch report (or plots).
  static int[]    voteRace;  // Race index by candidate   
  static char[]   voteArray; // the votes for this Ballot
  static int   voteBallot = 0; // total Ballots
  static int   b          = 0; // current batch #               
  static int     cummBallot; // cumm ballot for All Batch report (or plots).
  static int[]  batchBallot; // # ballots per batch
  static int[][]  batchVote; // votes per batch
  static JLabel    []   raceLabel1; // = new JLabel[maxRace];
  static JLabel    []   raceLabel2; // = new JLabel[maxRace];
  static JLabel    []   raceLabel3; // = new JLabel[maxRace];
  static JCheckBox []   voteBox;    // = new JCheckBox[maxVote];
  static JLabel    []    totLabel;  // = new JLabel[maxVote];
  static JLabel    []    batLabel;  // = new JLabel[maxVote];
  static boolean   printOn = false;    // print reports?
  static String    today;              // set by MenuAction Listener

  static JFrame frame; 

  //notes on static and final: -----------------------------------------------
  //  static means it is a class variable, not an instance variable.
  //  static means it can be accessed from any method (funtionally global)
  //  final means it can not be changed, however if it is an array,
  //        then the individual array values can be changed.
  //  final can be accessed from the "inner" classes, but not other methods.
  //  ------------------------------------------------------------------------
  
  public static void main(String[] parm) 
  {
    
    Integer tempInt;
    d.syslog("syslog.txt");
    d.setNoStop();
    
    d.display("JsrVote--"+COPYRIGHT);
    d.display("JsrVote--Font: "+defaultFont.toString());
    if (parm.length < 1)
    {  d.display("JsrVote-must contain one argument:");
       d.display("--------parm 1: file prefixy (i.e., 'share93')");
       return;
    }
    inputFile  [0] = parm[0]+"i.txt"; // input "INI" file 
    reportFile [0] = parm[0]+"r.txt"; // report file
    print1Parm [0] = reportFile[0];   // print from report file 
    input.read(inputFile);
    while (inputFile[1].substring(0,1).equals("="))
    {
        if (inputFile[1].substring(0,10).equals("=printNAM "))
        {
            print1Parm[1] = inputFile[1].substring(10);
            d.display("JsrVote--printNAM: "+print1Parm[1]);
        }
        if (inputFile[1].substring(0,10).equals("=printTYP "))
        {
            print1Parm[3] = inputFile[1].substring(10);
            d.display("JsrVote--printTYP: "+print1Parm[3]);
        }
        if (inputFile[1].substring(0,10).equals("=printLPP "))
        {
            tempInt = new Integer(inputFile[1].substring(10,13));
            printLPP = tempInt.intValue();
            d.display("JsrVote--printLPP="+printLPP);
        }
        input.read(inputFile);
    }
    
    voteTitle = inputFile[1];
    d.display("JsrVote--Title: "+voteTitle);
    input.read(inputFile);
    tempInt = new Integer(inputFile[1].substring(0,3));
    maxBatch = tempInt.intValue();
    d.display("JsrVote--maxBatch: "+maxBatch);
    input.read(inputFile);
    tempInt = new Integer(inputFile[1].substring(0,2));
    batchSize = tempInt.intValue();
    d.display("JsrVote--batchSize: "+batchSize);
    input.read(inputFile);
    tempInt = new Integer(inputFile[1].substring(0,2));
    maxRace = tempInt.intValue();
    d.display("JsrVote--maxRace: "+maxRace);
    input.read(inputFile);
    tempInt = new Integer(inputFile[1].substring(0,2));
    maxVote = tempInt.intValue();
    d.display("JsrVote--maxVote: "+maxVote);
    
    // the following are static (class) variables, accessible from inner classes
    // and from all methods.  They are declared static at top of class, then
    // their actual allocation size determined after size parameters are input.
     voteMax   = new       int[maxRace];  // Max # votes/Race (card input)
     raceName  = new    String[maxRace];  // Race Name        (card input)
     voteName  = new    String[maxVote];  // Candidate name   (card input)
    
     raceVotes = new       int[maxRace];  // # votes this Ballot by Race
     voteCount = new       int[maxVote];  // # votes by candidate 
     cummCount = new       int[maxVote];  // # votes by candidate 
     voteRace  = new       int[maxVote];  // Race index by candidate   
     voteArray = new      char[maxVote];  // the votes for this Ballot

   batchBallot = new       int[maxBatch]; // # ballots per batch
     batchVote = new       int[maxBatch][maxVote]; // votes per batch

    // d.display("Initializing b="+b);
    batchBallot[b] = 0;
    for (int i=0; i < maxVote; i++) batchVote[b][i] = 0;

    raceLabel1 = new JLabel[maxRace];
    raceLabel2 = new JLabel[maxRace];
    raceLabel3 = new JLabel[maxRace];
    voteBox   = new JCheckBox[maxVote];
    totLabel  = new JLabel[maxVote];
    batLabel  = new JLabel[maxVote];

    for (int i = 0; i < maxRace; i++)
    {
        raceVotes[i] = 0;
        raceName[i]  = "  ";
    }
    int ir = -1;  // individual race counter! 

    for (int iv = 0; iv < maxVote; iv++)
    {
        input.read(inputFile);  // add checking for input file and race change
        // d.display("Input: "+inputFile[1]+"***");
        if (!(inputFile[1].substring(0,1).equals("(")))
        {
            tempInt = new Integer(inputFile[1].substring(0,2));
            ir++;
            voteMax[ir] = tempInt.intValue();
            raceName[ir] = inputFile[1].substring(3);
            d.display("JsrVote--voteMax["+ir+"]: " + voteMax[ir] +
                      " raceName["+ir+"]: " + raceName[ir]);
            input.read(inputFile);
        } // can't have two ##Race Name in a row,
          // so next card is assumed to be in (k) Candidate Name format
        voteName[iv] = inputFile[1];
        d.display("JsrVote--Candidate: " + voteName[iv]
                  +" Race: " + raceName[ir]);
        voteRace[iv] =  ir;
    }
    //  ini file finished, now set up frame
    

    try {        UIManager.setLookAndFeel(
            UIManager.getSystemLookAndFeelClassName());
        } catch (Exception e) { }  // set Look and Feel to Windows
        // System=Windows on Win32 systems, CrossPlatform=Metal (Java default)

    frame = new JFrame(voteTitle);
    frame.addWindowListener(new JsrWindowExit());
    // System.out.println("Frame created ");

    // A simple menu class w/ Action listener (see page 419-420 Java Swing)
    class VoteMenuListener extends JMenuBar implements ActionListener
    {
        String[]   fileItems   = new String[] {"Exit"};
        char[]     fileShortCuts =            {'x'};
        String[]   reportItems = new String[] {"This Batch",
                                               "All Batches",
                                               "Plot Votes"};
        char[] reportShortCuts =              {'T','A','P'};
        public VoteMenuListener()  // constructor
        {
            JMenuItem fileItem;
            JMenu fileMenu = new JMenu("File");
            fileMenu.setMnemonic('F');
            for (int i=0; i < fileItems.length; i++)
            {
                fileItem = new JMenuItem(fileItems[i], fileShortCuts[i]);
                fileItem.addActionListener(this);
                fileMenu.add(fileItem);
            }
            add(fileMenu); 
            JMenuItem reportItem;
            JMenu reportMenu = new JMenu("Reports");
            reportMenu.setMnemonic('R');
            for (int i=0; i < reportItems.length; i++)
            {
                reportItem = new JMenuItem(reportItems[i], reportShortCuts[i]);
                reportItem.addActionListener(this);
                reportMenu.add(reportItem);
            }
            reportMenu.add(reportItem = new JCheckBoxMenuItem("Print On/Off"));
            reportItem.addActionListener(this);
            add(reportMenu);
        }
        public void actionPerformed(ActionEvent menuEvent)
        {
            String menuItem=menuEvent.getActionCommand();
            // will do report logic from here
            Calendar rightNow = Calendar.getInstance();
            today = u.getDateTime();
            if (menuItem.equals("Print On/Off")) printOn = !printOn;
            // intuit printOn value rather than generate ItemListener 
            System.out.println("Menu="+ menuItem+" printOn/Off="+printOn+" "+today);
            if (menuItem.equals("This Batch"))  doThisReport();
            if (menuItem.equals("All Batches")) doAllReport();
            if (menuItem.equals("Plot Votes")) doPlotVotes();
            if (menuItem.equals("Exit"))
            {
                d.display("Exiting");
                output.close();
                System.exit(0);
            }
        }
    }  // end class VoteMenuListener

    // A simple ActionListener.
    class VoteActionListener implements ActionListener
    {
      public void actionPerformed(ActionEvent ex)
      {
        String choice = ex.getActionCommand();
        Integer vInteger = new Integer(choice);
        int v = vInteger.intValue();
        System.out.println("ACTION Candidate[" + choice + "] Selected!");
        voteBox[v].setSelected(true);
        // the above invokes itemStateChanged if it is a change
      }
    } // end class VoteActionListener

    // A simple ItemListener, showing each selection and deselection.
    class VoteItemListener implements ItemListener
    {
      public void itemStateChanged(ItemEvent ex)
      {
       String item =
          ((AbstractButton)ex.getItemSelectable()).getActionCommand();
        
        boolean selected = (ex.getStateChange() == ItemEvent.SELECTED);
        Integer vInteger = new Integer(item);
        int v = vInteger.intValue();
        if (selected)
        {
            // System.out.println("voteArray[v]="+voteArray[v]+ "true");
            if (voteArray[v] == '0')
            {
                if (raceVotes[voteRace[v]] == voteMax[voteRace[v]])
                {
                    JOptionPane.showMessageDialog(frame,
                     "Maximum Votes this Race = "+voteMax[voteRace[v]]);
                     voteBox[v].setSelected(false);
                }
                else
                {
                    voteArray[v] = '1';
                    raceVotes[voteRace[v]]++;
                }
            }
        }
        else
        {
            // System.out.println("voteArray[v]="+voteArray[v]+ "false");
            if (voteArray[v] == '1')
            {
                voteArray[v] = '0';
                raceVotes[voteRace[v]]--;
            }
        }
        String voteString = "";
        for (int i = 0; i < maxVote; i++) voteString += voteArray[i]+",";
        
        System.out.println("  ITEM Candidate[" + item + "]: "  +
          " Votes=" + voteString + "* On/off=" + selected +
          " raceVotes=" + raceVotes[voteRace[v]] +
          " " + voteName[v]);
      }
    } // end class VoteItemListener



    // p1+i.txt Initialization file read
    // following renames will only work if files are closed (OK here, see JsrEdit.java).
     inputFile[0] = parm[0]+"v.$$$";
    outputFile[0] = parm[0]+"v.txt";
    File  txtFD = new File(outputFile[0]);
    File tempFD = new File( inputFile[0]);
    if (txtFD.exists() != true)
    {
        d.display("JsrVote--File: "+outputFile[0]+" does not exist!");
        System.exit(4);
    }
    if (tempFD.exists() == true) 
        d.display("JsrVote--delete " + tempFD+"=" + tempFD.delete());
    d.display("JsrVote--rename "+txtFD+ " to "
                       + tempFD+"=" + txtFD.renameTo(tempFD));
    input.read(inputFile);  // copy header line
    outputFile[1] = inputFile[1];
    output.write(outputFile);

    String         acString  = " "; 
    ActionListener al = new VoteActionListener();
    ItemListener   il = new VoteItemListener();

    // System.out.println("Initializing constants");

    for (int i = 0; i < maxRace; i++)
    {
        d.display("Initializing raceLabel["+ i +"]: "+raceName[i]);
        raceLabel1[i] = new JLabel(raceName[i]);
        raceLabel1[i].setFont(defaultFont);
        raceLabel2[i] = new JLabel("   ",SwingConstants.RIGHT);
        raceLabel3[i] = new JLabel("   ",SwingConstants.RIGHT);
    }

    for (int i = 0; i < maxVote; i++)
    {
        // System.out.println("Initializing totLabel["+i+"]");
        voteArray[i] = '0';
        voteCount[i] =  0;
        batLabel[i] = new JLabel("0",JLabel.RIGHT);
        batLabel[i].setFont(defaultFont);
        totLabel[i] = new JLabel("0",JLabel.RIGHT);
        totLabel[i].setFont(defaultFont);
        voteBox[i] = new JCheckBox(" "+voteName[i], false);
        voteBox[i].setToolTipText("Check Box or type underlined # to select.");
        voteBox[i].setFont(defaultFont);
        tempInt = new Integer(i);
        acString   = tempInt.toString();
        voteBox[i].setActionCommand(acString);
        voteBox[i].setMnemonic(voteName[i].charAt(1));
        KeyStroke aKey = KeyStroke.getKeyStroke(voteName[i].charAt(1));
        voteBox[i].addItemListener(il);
        voteBox[i].registerKeyboardAction(al,acString,aKey,
               JComponent.WHEN_IN_FOCUSED_WINDOW);
    }


    // System.out.println("Constants set ");
    // now can continue with input file
    String vChar;
    while (0 <= input.read(inputFile))
    {
        // System.out.println("Input VoteString: "+inputFile[1]);
        if (inputFile[1].length() < (maxVote*2))
        {
           d.display("Skipping line of length="+inputFile[1].length());
        }
        else
        {   
            newVote (); 
            for (int v=0; v < maxVote; v++)
            {
                vChar = inputFile[1].substring(v*2,v*2+1);    
                // System.out.println("v="+v+"v*2="+(v*2)+"=="+vChar);
                if (vChar.equals("1"))
                {
                   voteCount[v]++;
                   batchVote[b][v]++;
                }
            }
            voteBallot++;
            batchBallot[b]++;
            writeBallot(inputFile[1]);
        }
       
    }
    // System.out.println("After input votes.");
    batSumLabel.setText(" "+ batchBallot[b]);
    totSumLabel.setText("Total: " + voteBallot);
    for (int v=0; v < maxVote; v++)
    {
        batLabel[v].setText(" "+batchVote[b][v]);
       totLabel[v].setText(" "+voteCount[v]);
    }
   

    // Throw everything together.
    frame.setJMenuBar(new VoteMenuListener());
    Container c = frame.getContentPane();

    c.setLayout(new GridLayout(maxVote+maxRace+2,3)); // items added left to right

    batHead.setText("Batch # "+(b+1));
    batHead.setFont(defaultFont);
    totHead.setFont(defaultFont);
    c.add(dotLabel1);
    c.add(batHead);
    c.add(totHead);

    ir = -1;
    for (int i = 0; i < maxVote; i++)
    {
        if (voteRace[i] != ir)
        {
            ir = voteRace[i];
            c.add(raceLabel1[ir]);
            c.add(raceLabel2[ir]);
            c.add(raceLabel3[ir]);
        }
        c.add(voteBox[i]);
        c.add(batLabel[i]);
        c.add(totLabel[i]);
     
    }
    JButton voteButton = (new JButton("Vote"));
    voteButton.setMnemonic('V');
    voteButton.setToolTipText("Press Vote button (or enter) to cast one ballot.");
    voteButton.addActionListener(new ActionListener()
    {
        public void actionPerformed(ActionEvent ev)
        {
            String voteString = "";
            newVote(); 
            if (batchBallot[b] == 0)
            {
                batHead.setText("Batch # "+(b+1));
                for (int i = 0; i < maxVote; i++)
                    batLabel[i].setText(" "+batchVote[b][i]);
                    // reset labels to zero if batch changes
            }
            
            for (int i = 0; i < maxVote; i++)
            {
                voteString += voteArray[i]+",";
                if (voteArray[i] == '1')
                {
                    // voteArray[i] = '0'; this will be done by itemListener
                    voteBox[i].setSelected(false);
                    batchVote[b][i]++;
                    voteCount[i]++;
                    batLabel[i].setText(" "+batchVote[b][i]);
                    totLabel[i].setText(" "+voteCount[i]);
                }
            }
            voteBallot++;
            batchBallot[b]++;
            batSumLabel.setText(" "+ batchBallot[b]);
            totSumLabel.setText("Total: " + voteBallot);
            voteString += u.padZero(voteBallot,5);
            for (int i = 0; i < maxRace; i++)  raceVotes[i] = 0;
	               
            System.out.println("Vote Button Pressed, Votes=" + voteString);
            writeBallot(voteString);
            if (batchBallot[b] == batchSize)
                    JOptionPane.showMessageDialog(frame,
                     "Please generate This Batch Report now.  \n"+
                     "Thanks, and Have a Nice Day!");
        }
    });   //  yes that is } bracket and ) parenthesis.
    
    c.add(voteButton);
    batSumLabel.setFont(defaultFont);
    totSumLabel.setFont(defaultFont);
    c.add(batSumLabel);
    c.add(totSumLabel);

    // System.out.println("Frame display ");
    
    frame.pack(); // sets size to just as big as it needs to be
    // frame.setSize(600,600); // or could set to specific size
   
    frame.setVisible(true);
    voteButton.grabFocus();  // must be done after screen is visible
                             // try grabFocus vs. requestFocus   
  }

  public static void newVote()
  {
      // d.display("newVote: b="+b+" batchBallot[b]="+batchBallot[b]+"batchSize="+batchSize);      
      if (batchBallot[b] == batchSize)
      {
          b++;
          batchBallot[b] = 0;
          for (int i=0; i < maxVote; i++) batchVote[b][i] = 0;
      }
  }

  public static void writeBallot(String voteString)
  {
      outputFile[1] = voteString;  
      output.write(outputFile);   
  }

  public static void doAllReport()
  {
    d.display("doAllReport called, Last Batch # "+(b+1));
    for (int i=0; i < maxVote; i++) cummCount[i] = 0;
    cummBallot = 0;
    lineCount = 999; // force report to page break
    for (int bt=0; bt <= b; bt++)
    {
      //d.display("lineCount="+lineCount+"/"+printLPP);
      if  ((lineCount+maxVote+4) > printLPP)
      {
          printOneLine("1JsrVote    "+voteTitle);
          printOneLine(" "+today+"        All Batches  Report");
          lineCount = 4;
      }
      lineCount++;  // extra bump for double space
      printOneLine("0Race & Candidate         Batch #"+u.padLeft(bt+1, 3)+"  All Batches");
      for (int i=0; i < maxVote; i++)
      {
          if ((i == 0) || (voteRace[i] != voteRace[i-1]))
              printOneLine(raceName[voteRace[i]]);
          cummCount[i] += batchVote[bt][i];
          printOneLine(" "+u.padRight(voteName[i],25)
                          +u.padLeft(batchVote[bt][i],10)
                          +u.padLeft(cummCount[i],12));
      }
      cummBallot += batchBallot[bt];
      printOneLine(" Totals                   " +u.padLeft(batchBallot[bt],10)
                                                +u.padLeft(cummBallot,12));
    }
    report.close();
    if (printOn) print1.main(print1Parm);
  }

  public static void doThisReport()
  {
      System.out.println("doThisReport called, Batch # "+(b+1));
      lineCount = 999; // force report to page break
      if  (lineCount > printLPP)
      {
          printOneLine("1JsrVote    "+voteTitle);
          printOneLine(" "+today+"      Current Batch  Report");
          lineCount = 4;
      }
      printOneLine("0Race & Candidate         Batch #"+u.padLeft(b+1, 3)+"  All Batches");
      for (int i=0; i < maxVote; i++)
      {
          if ((i == 0) || (voteRace[i] != voteRace[i-1]))
              printOneLine(raceName[voteRace[i]]);
          printOneLine(" "+u.padRight(voteName[i],25)
                          +u.padLeft(batchVote[b][i],10)
                          +u.padLeft(voteCount[i],12));
      }
      printOneLine(" Totals                   " +u.padLeft(batchBallot[b],10)
                                                +u.padLeft(voteBallot,12));
      report.close();
      if (printOn) print1.main(print1Parm);
  }

  public static void doPlotVotes()
  {
      
      d.display("doPlotVotes called, Batch # "+(b+1));
      lineCount = 999; // force report to page break
      if  (lineCount > printLPP)
      {
          printOneLine("1JsrVote    "+voteTitle);
          printOneLine(" "+today+"      Plot Votes");
          lineCount = 4;                           
      }
      printOneLine("0# Ballots Cast: "+u.padLeft(voteBallot,12));
      int plotSpread = 80 / (b+1);
      //d.display("alloc plotChar[50]["+plotSpread*(b+1)+"]");
      char [][] plotChar = new char[50][plotSpread*(b+1)];
      for (int i=0; i < 50; i++)
          for (int j=0; j < (plotSpread*(b+1)); j++)
              plotChar[i][j] = ' ';
      //d.display("init cummCount");
      for (int i=0; i < maxVote; i++) cummCount[i] = 0;
      for (int bt=0; bt <= b; bt++)
      {
        for (int i=0; i < maxVote; i++)
        {
            //d.display("CummCount set="+ cummCount[i] +"+="+ batchVote[bt][i] );
            cummCount[i] += batchVote[bt][i];
            int p = (cummCount[i] * 50) / voteBallot;
            //d.display("bt="+bt+" * X="+(plotSpread*bt)+" p="+p+
              //        " Vote="+cummCount[i]+" Who: "+voteName[i]);
            if (plotChar[p][plotSpread*bt] == ' ')
                plotChar[p][plotSpread*bt] = voteName[i].charAt(1);
            else
                plotChar[p][plotSpread*bt] = '*';
            //d.display("after set plotChar...");
        }
      }
      for (int p=49; p >=0; p--)
      {
         String printString = new String("          |");
         if (p == 49) printString = u.padLeft(voteBallot,10) + "+";
         if (p == 36) printString = u.padLeft(voteBallot*3/4,10) + "+";
         if (p == 24) printString = u.padLeft(voteBallot/2,10) + "+";
         if (p == 11) printString = u.padLeft(voteBallot/4,10) + "+";
         for (int bt=0; bt<=(plotSpread*b); bt++) printString += plotChar[p][bt];
         printOneLine(" "+printString);
      }
      printOneLine("          0+---------+---------+---------+---------+"+
                               "---------+---------+---------+---------+");
      printOneLine("            Batches->");
      report.close();
      if (printOn) print1.main(print1Parm);
  }


  public static void printOneLine(String oneLine)
  {
      reportFile[1] = oneLine.substring(0,1)+"        "+oneLine.substring(1);
      report.write(reportFile);
      lineCount++;
  }


  
}
// end of JsrVote.java program