/******************************************************************************
// JsrUtil.java:   padLeft, padRight, string or integer input.
//                 output is padded or truncated as necessary.
 * Sample Use:
 * import JsrUtil;                  ... 
 * JsrUtil u = new JsrUtil();
 * paddedString  = u.padLeft(oldString,10);
 * paddedInteger = u.padLeft(oldInt,10);
 * zeroPadInt    = u.padZero(oldInt,10);
 * paddedString  = u.padRight(oldString,10);
 * dateTime      = u.getDateTime();
 * 
*/
import java.util.*;

public class JsrUtil
{ 
  static final String COPYRIGHT = 
  "Copyright 1998, JSR Systems.  See: www.Jsrsys.com/copyright.";

  public JsrUtil()  // null constructor
  {
  }

  String padLeft(String parmString, int parmLen)   
  {
     String tempString = parmString;
     if (tempString.length()    > parmLen)
        tempString = tempString.substring(tempString.length()-parmLen,
                                          tempString.length());
     else
     {
        while (tempString.length() < parmLen)
          tempString = " "+tempString;
     }
     return tempString;  
  } 

  String padLeft(int parmInt, int parmLen)   
  {
     Integer tempInt    = new Integer(parmInt);
     String  tempString = tempInt.toString();
     return padLeft(tempString, parmLen);
  } 

  String padZero(int parmInt, int parmLen)   
  {
     Integer tempInt    = new Integer(parmInt);
     String  tempString = tempInt.toString();
     if (tempString.length()    > parmLen)
        tempString = tempString.substring(tempString.length()-parmLen,
                                          tempString.length());
     else
     {
        while (tempString.length() < parmLen)
          tempString = "0"+tempString;
     }
     return tempString;  
  } 

  String padRight(String parmString, int parmLen)   
  {
     String tempString = parmString;
     if (tempString.length()    > parmLen)
        tempString = tempString.substring(0,parmLen+1);
     else
     {
        while (tempString.length() < parmLen)
          tempString = tempString + " ";
     }
     return tempString;  
  } 

  String getDateTime()   
  {
      Calendar rightNow = Calendar.getInstance();
      String   today = rightNow.get(Calendar.YEAR)+"-"+
               padZero(rightNow.get(Calendar.MONTH)+1,2)+"-"+
               padZero(rightNow.get(Calendar.DAY_OF_MONTH),2)+"@"+
               padZero(rightNow.get(Calendar.HOUR_OF_DAY),2)+":"+
               padZero(rightNow.get(Calendar.MINUTE),2);
       // add 1 to month because Calendar returns 0 for January!!!
     return today;
  }

} 
