 /******************************************************************************
// JsrSysout.java:    
 * to simplify display/accept logic for debugging.
 * Sample Use:
 * import JsrSysout;                  ... 
 * JsrSysout d = new JsrSysout();  ...
 * d.display("Text to display");
 * d.accept ("Text to display");  
 * each instance of JsrSysout will save the last character entered from accept.
 * if that character is "q" (113), lower case q, subsequent calls to that
 *    instance will neither display (System.out.println), 
 *                      nor accept  (System.in.read()).     
 * 1998/08/18 modification.  If user enters "R" (for Run),
 *    displays will continue, but user will not be prompted for input.
 *
 * 1999-08-25 modifications:
 *    d.syslog("syslog.txt");  // will log to file syslog.txt.
 *    d.setNoStop();           // sets qBig to "R".

 
*/

import java.io.*;
public class JsrSysout
{ 
  static final String COPYRIGHT = 
  "Copyright 1998, JSR Systems.  See: www.Jsrsys.com/copyright.";

  static final int MAXLINELEN = 80;
  static final int MAXSCREEN  = 21;
  static int qBig = ' ';  //  81 "Q" to terminate all instances 
                          //  82 "R" run, do not query user any more
  int       qChar = ' ';  // 113 "q" to terminate this instance
  static int nLines = 0;
  static String[]   syslogLine = new String[] {"",""};
  static JsrLineOut syslogFile = new JsrLineOut("NoLog");
  // any string in constructor will suppress recursive calls to JsrSysout
  public JsrSysout()  // null constructor
  {
  }

  void display(String displayString)
  {  
     if (qChar != 113 && qBig != 81)
     {
        // System.out.println("Last q="+qChar+", Last Q="+qBig);
        nLines += (displayString.length()+MAXLINELEN)/MAXLINELEN;
        if (nLines > MAXSCREEN)
           accept(displayString);
        else   
        System.out.println(displayString);
        if (syslogLine[0].length() > 0)
        {
            syslogLine[1] = displayString;
            syslogFile.write(syslogLine);
        }
     }
     return;
  } 

  void accept(String displayString)
  {
     if (qChar != 113 && qBig != 81) 
     {
        // System.out.println("Last q="+qChar+", Last Q="+qBig);
        System.out.println(displayString);
        if (syslogLine[0].length() > 0)
        {
            syslogLine[1] = displayString;
            syslogFile.write(syslogLine);
        }
        nLines = (displayString.length()+MAXLINELEN)/MAXLINELEN;
        if (qBig != 82)
        {
          System.out.println("Waiting for input..."+
             "(Press [Enter], or \"q\", or \"Q\", "+
             "or \"R\", then [Enter].)");
          try {qChar = System.in.read();System.in.read();}
               catch (IOException eIO){}
          qBig = qChar;  // if "Q" will terminate all instances.
                         // if "q" will terminate this instance.
        }
     }
     return;
  }
  void setNoStop()
  {
      qBig = 'R';
      return;
  }

  void syslog(String fileName)
  {
      syslogLine[0] = fileName;
      return;
  }
  
} 