/******************************************************************************
// JsrLineOut.java:    
 * Sample Use:
 * import JsrLineOut;                  ... 
 * JsrLineOut file1 = new JsrLineOut();
 * String[] strfile1[2];
 * strfile1[0] = "C:\reqlook.dxx"
 * file1.Write(strfile1[]))
*/

import java.io.*;
import JsrDebug;
public class JsrLineOut
{ 
  static final String COPYRIGHT = 
  "Copyright 1998, JSR Systems.  See: www.Jsrsys.com/copyright.";

  int                   recNum = 0;
  String                fileName = "";
  DataOutputStream       outFileStream;
  DataOutput             outFile;
  JsrSysout d;
  boolean displayOn;
  public JsrLineOut()  // null constructor
  {
     d = new JsrSysout();
     displayOn = true;
  }
  public JsrLineOut(String noLog)  // constructor to not log
  {  displayOn = false;            // used by JsrSysout itself
  }                                // to avoid recursive calls

  int open(String parmName)   
  {
     if (recNum != 0)
     {
        close();
     }
     if (displayOn) d.display("Open  Output: " + parmName);   
     // open code here
     fileName = parmName;
     recNum = 0;
     try {outFileStream =
             new DataOutputStream(new FileOutputStream ( fileName));
          outFile =  outFileStream;
         } catch ( IOException  eIO )
                 {System.out.println("I/OError! "   + fileName); 
                  recNum=-1; 
                 } 
     return recNum;
  } 
  int close()   
  {  
     if (recNum > 0)
     {
       if (displayOn) d.display("Close Output: " + fileName + " Records out=" + recNum);   
       try {outFileStream.close();   // free up resource
           }catch ( IOException  eIO )
                  {System.out.println("I/OError! "   + fileName); }
     }
     recNum   = - recNum;
     fileName = "";
     return recNum;
  } 
  int write(String nameRecord[])   
  {
     // if (displayOn) d.display("Read: " + nameRecord[0] + nameRecord[1]);   
     if (!nameRecord[0].equals(fileName))
     {
        open(nameRecord[0]);
     }
     if (recNum >= 0)
     {
       try { outFile.writeBytes(nameRecord[1]+"\r\n");
           } catch ( IOException  eIO )
                   {System.out.println("I/OError! "   + fileName); }
     }
     recNum++;
     return recNum;
  } 
} 